# CVE-2024-58290-Xhibiter-SQLi
Proof of Concept (PoC) for SQL Injection in Xhibiter NFT Marketplace 1.10.2 (Collections Endpoint). Discovered by Sohel Yousef.

# CVE-2024-58290: Xhibiter NFT Marketplace SQL Injection

**Exploit Title:** Xhibiter NFT Marketplace 1.10.2 - SQL Injection (Unauthenticated)  
**Date:** 2024-12-11  
**Exploit Author:** Sohel Yousef  
**Vendor Homepage:** https://themeforest.net/user/deothemes
**Software Link:** https://themeforest.net/item/xhibiter-nft-marketplace-html-template/36542347
**Version:** 1.10.2  
**Tested on:** Linux / Windows  
**CVE:** CVE-2024-58290  

## Description
A critical SQL Injection vulnerability exists in Xhibiter NFT Marketplace version 1.10.2. The vulnerability is located in the `collections` endpoint via the `id` parameter. This allows remote unauthenticated attackers to execute arbitrary SQL commands, potentially leading to data exfiltration or database manipulation.

## Technical Details
- **Vulnerable Parameter:** `id`
- **Endpoint:** `/collections`
- **Injection Type:** Boolean-based / Time-based Blind
- **Attack Vector:** Remote (Network)

## Proof of Concept (PoC)
I have developed a Python script to automate the detection of this vulnerability. The script sends a benign payload to verify the database response time delay (Time-Based SQLi Check).

### Usage
```bash
python3 poc.py --url [http://target-site.com](http://target-site.com)
