# CVE‑2024‑58258 – SugarCRM SSRF & Local File Disclosure

## About

This repository provides a proof‑of‑concept for **CVE‑2024‑58258**, a
SugarCRM (\<13.0.4 / \<14.0.1) vulnerability where user input is parsed
as LESS in the `/css/preview` API, allowing unauthenticated SSRF or
local file access.

## Affected Versions

-   All commercial editions prior to **13.0.4**
-   All commercial editions prior to **14.0.1**

## Description

SugarCRM does not properly sanitize user‑supplied GET parameters in the
`/css/preview` REST endpoint. The input is interpreted as LESS code,
enabling attackers to inject arbitrary LESS directives.\
Abusing `@import` may allow: - **SSRF (Server‑Side Request Forgery)** -
**Local File Disclosure**

This can lead to exposure of internal or sensitive data.

## CLI Usage

    usage: main.py [options] target file_or_url

    positional arguments:
      target               Target SugarCRM URL
      file_or_url          File path or URL to access

    optional arguments:
      -p, --proxy PROXY    Proxy server
      -v, --verbose        Verbose output
      -t, --test           Test vulnerability first

## Credits

Vulnerability discovered by **Egidio Romano**.

## References

-   Karma In Security Advisory:
    https://karmainsecurity.com/KIS-2025-04
-   SugarCRM Security Advisory:
    https://support.sugarcrm.com/resources/security/sugarcrm-sa-2024-059/
-   Official SugarCRM Website: https://www.sugarcrm.com
-   CVE Entry:
    https://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2024-58258

## Disclaimer

This project is for **educational and research purposes only**.\
Do not use this proof‑of‑concept on systems without explicit permission.
Unauthorized testing is illegal and unethical.
