define cc
    disable break
    c
    enable break
end

define i
    file ./releases/mitigation-v4-6.6/vmlinux
    dir ../source/mitigation466
    target remote :1234
    # b *tls_strp_msg_done
    # b *kfree_skbmem

    # b *kfree_skb_list_reason

    # b net/tls/tls_sw.c:2732
    # b consume_skb
    # b *kfree_skb_list_reason
    # b *tls_sk_proto_close
    # b tls_sw_recvmsg
    # get the address of the page
    b net/tls/tls_sw.c:2027
    # b process_rx_list
    # load-vmlinux
    # b kfree_skbmem
    # b *unix_stream_sendmsg
    # b *tcp_time_wait
    b do_splice
    c
end

define dm
    # b *pipe_read+0xea if $rdi=$page
# remember to set $pipe=pipe
    b *0xffffffff814b7cc2 if $rax==$page
    b *0xffffffff82050f28 if $rbx==$page
    b *tls_strp_done
    b *pipe_read+0xe2 if $rdi==$page
    b *alloc_slab_page_virtual+0x317 if $rax==$page
    b *pipe_read+0x8f if $r15==$pipe
end

define wut
    p *(struct skb_shared_info*) ((*(struct sk_buff*)$anchor).head + (*(struct sk_buff*)$anchor).end)
    set $page=(*(struct skb_shared_info*) ((*(struct sk_buff*)$anchor).head + (*(struct sk_buff*)$anchor).end)).frags[0].bv_page
    set $a=(*(struct skb_shared_info*) ((*(struct sk_buff*)$anchor).head + (*(struct sk_buff*)$anchor).end)).frag_list
    # b net/core/skbuff.c:981
    dm
end

define a
    p (*(struct skb_shared_info*) ((*(struct sk_buff*)$anchor).head + (*(struct sk_buff*)$anchor).end)).frag_list
end

define hihi
    set $ctx=ctx
    set $anchor=$ctx->strp.anchor
end

# =============== PYTHON UTIL ==================
define page_to_virt
    set $page = $arg0
    set $offset = ((unsigned long)$page - (unsigned long)vmemmap_base) >> 6
    set $virt = ($offset << 12) + page_offset_base
    p/x $virt
end

define load-vmlinux
  python
import re
from gdb import execute

# Step 1: Get kernel base
kbase_out = execute("kbase", to_string=True)
kbase_match = re.search(r'kernel text:\s+([^\s-]+)-', kbase_out)
if not kbase_match:
    raise Exception("[-] Failed to extract kbase")
kbase = int(kbase_match.group(1), 16)
print(f"[+] Kernel base: {hex(kbase)}")

# Step 2: Get _text address
text_out = execute("print _text", to_string=True)
text_match = re.search(r'\$[0-9]+\s+=\s+(0x[0-9a-f]+)', text_out)
if not text_match:
    raise Exception("[-] Failed to extract _text address")
text_addr = int(text_match.group(1), 16)
print(f"[+] _text address: {hex(text_addr)}")

# Step 3: Compute offset
offset = kbase - text_addr
print(f"[+] Offset: {hex(offset)}")

# Step 4: Load symbol file
execute(f"symbol-file ./releases/mitigation-v4-6.6/vmlinux -o {offset:#x}")
print("[+] symbol-file loaded.")
  end
end

