define cc
    disable break
    c
    enable break
end

define i
    file ./releases/lts-6.6.19_1/vmlinux
    dir ../build/builds/lts-6.6.19_1/
    target remote :1234

    load-vmlinux
    # b net/tls/tls_sw.c:2009
    # b net/tls/tls_sw.c:1594
    b consume_skb
end

# =============== PYTHON UTIL ==================
define page_to_virt
    set $page = $arg0
    set $offset = ((unsigned long)$page - (unsigned long)vmemmap_base) >> 6
    set $virt = ($offset << 12) + page_offset_base
    p/x $virt
end

define load-vmlinux
  python
import re
from gdb import execute

# Step 1: Get kernel base
kbase_out = execute("kbase", to_string=True)
kbase_match = re.search(r'kernel text:\s+([^\s-]+)-', kbase_out)
if not kbase_match:
    raise Exception("[-] Failed to extract kbase")
kbase = int(kbase_match.group(1), 16)
print(f"[+] Kernel base: {hex(kbase)}")

# Step 2: Get _text address
text_out = execute("print _text", to_string=True)
text_match = re.search(r'\$[0-9]+\s+=\s+(0x[0-9a-f]+)', text_out)
if not text_match:
    raise Exception("[-] Failed to extract _text address")
text_addr = int(text_match.group(1), 16)
print(f"[+] _text address: {hex(text_addr)}")

# Step 3: Compute offset
offset = kbase - text_addr
print(f"[+] Offset: {hex(offset)}")

# Step 4: Load symbol file
execute(f"symbol-file ./releases/lts-6.6.19_1/vmlinux -o {offset:#x}")
print("[+] symbol-file loaded.")
  end
end
