#!/bin/bash
set -e

usage() {
    echo "Usage: $0 <release-name> [--root] [--gdb]";
    exit 1;
}

INIT_FN="/home/user/run.sh"
RUN_GDB=false

ARGS=()
while [[ $# -gt 0 ]]; do
  case $1 in
    --root) INIT_FN="/bin/bash"; shift;;
    --gdb) RUN_GDB=true; shift;;
    -*|--*) echo "Unknown option $1"; exit 1;;
    *) ARGS+=("$1"); shift;;
  esac
done
set -- "${ARGS[@]}"

RELEASE_NAME="$1"
if [ -z "$RELEASE_NAME" ]; then usage; fi

if [ "$RUN_GDB" = true ] && [ -n "$TMUX" ]; then
    tmux split-window -h "gdb -x ./script.gdb"
fi

exec ./qemu.sh "releases/$RELEASE_NAME" flag "$INIT_FN"
