# CVE-2024-58239 mitigation exploit

This is my first 1-day exploit. 

Patch: [tls: stop recv() if initial process_rx_list gave us non-DATA
](https://git.kernel.org/pub/scm/linux/kernel/git/torvalds/linux.git/commit?id=fdfbaec5923d9359698cbb286bc0deadbb717504)

I saw `exp407` on the [kernelCTF spreadsheet](https://docs.google.com/spreadsheets/d/e/2PACX-1vS1REdTA29OJftst8xN5B5x8iIUcxuK6bXdzF8G1UXCmRtoNsoQ9MbebdRdFnj6qZ0Yd7LwQfvYC2oF/pubhtml#) and tried to reproduce the exploit.

I managed to run the exploit on the kernelCTF environment and get the flag:
![image](https://hackmd.io/_uploads/Bkntd3P6eg.png)

I will write a detailed write-up for this later.

The log for the exploit is kinda long, due to a kernel WARNING in the middle. However, a warning is not an error and it doesn't kill my exploit ;)
![image](https://hackmd.io/_uploads/rkTNzTv6ge.png)

# Folder structure
I remove many heavy files from this folder.
* `./rootfs_v3.img`
* `./ramdisk_v1.img`
* `./releases/mitigation-v4-6.6/bzImage`
* `./releases/mitigation-v4-6.6/vmlinux`

You can get the first 3 files by running [original local_runner.sh](https://github.com/google/security-research/blob/master/kernelctf/simulator/local_runner.sh)

For the fourth one and source code, you can connect to the kernelCTF server and get links to download.

But for your convinience, here is the info of `mitigation-v4-6.6` instance:
```
Kernel image (bzImage): https://storage.googleapis.com/kernelctf-build/releases/mitigation-v4-6.6/bzImage
Kernel image (vmlinux): https://storage.googleapis.com/kernelctf-build/releases/mitigation-v4-6.6/vmlinux.gz
Kernel config: https://storage.googleapis.com/kernelctf-build/releases/mitigation-v4-6.6/.config
  -> derived from COS config: https://storage.googleapis.com/kernelctf-build/releases/mitigation-v4-6.6/lakitu_defconfig
Source code info: https://storage.googleapis.com/kernelctf-build/releases/mitigation-v4-6.6/COMMIT_INFO
```
Also, the commands to download `.img` files:
```bash
wget https://storage.googleapis.com/kernelctf-build/files/rootfs_v3.img.gz
gzip -d rootfs_v3.img.gz
wget https://storage.googleapis.com/kernelctf-build/files/ramdisk_v1.img
```

# Building the exploit
```bash
cd ./exploit/mitigation-v4-6.6/
make
```

# Running the exploit
This exploit is split into 2 parts: 
- the server to be run on a VPS first.
- the client to be run on the target machine, later.

Server:
```bash
./server --port <port>
```
Client:
```bash
./client --ip <server_ip> --port <port>
```
# Testing locally
I wrote 2 scripts to test the exploit locally:
## test.py
This one starts the server in the background, then run the client in the qemu VM.
### Set up
First, go to `exploit/mitigation-v4-6.6`, and start an http server on port 3000, to download the exploit to the qemu VM later
```bash
cd exploit/mitigation-v4-6.6
python3 -m http.server 3000
```
### Usage
Then, in another terminal, start the script:
```bash
python3 test.py <your_ip> <port>
```
* `<your_ip>` is your internet card's ip. For me, I run the entire thing in WSL, I run `ip a`, and get the IP of the `eth0` interface, `172.30.248.93`
```bash
➜  CVE-2024-58239 git:(main) ip a
1: lo: <LOOPBACK,UP,LOWER_UP> mtu 65536 qdisc noqueue state UNKNOWN group default qlen 1000
    link/loopback 00:00:00:00:00:00 brd 00:00:00:00:00:00
    inet 127.0.0.1/8 scope host lo
       valid_lft forever preferred_lft forever
    inet 10.255.255.254/32 brd 10.255.255.254 scope global lo
       valid_lft forever preferred_lft forever
    inet6 ::1/128 scope host
       valid_lft forever preferred_lft forever
2: eth0: <BROADCAST,MULTICAST,UP,LOWER_UP> mtu 1500 qdisc mq state UP group default qlen 1000
    link/ether 00:15:5d:22:a0:d1 brd ff:ff:ff:ff:ff:ff
    inet 172.30.248.93/20 brd 172.30.255.255 scope global eth0
       valid_lft forever preferred_lft forever
    inet6 fe80::215:5dff:fe22:a0d1/64 scope link
       valid_lft forever preferred_lft forever
```
* `<port>` is any unused port on your local machine. It's for the TLS connection between the client and the server.

## calc_AC_rate.py
This one run the exploit a number of time and measure the success rate of it.
### Set up
Like the usage of `test.py`, go to `exploit/mitigation-v4-6.6`, and start an http server on port 3000, to download the exploit to the qemu VM later
```bash
cd exploit/mitigation-v4-6.6
python3 -m http.server 3000
```
### Usage
```bash
python3 calc_AC_rate.py <your_ip> <port> <number_of_time_to_run>
```
For example, on my WSL, I run it as `python3 calc_AC_rate.py 172.30.248.93 1118 100`.

# Success rate
I'm still working on the success rate, as now it's kinda unstable. 

I run `calc_AC_rate.py` to test the exploit 100 times, and the result is `50/100`.

For the failed attempts, it's because of `common_interrupt` popping up in the middle, triggering naive double free detection in kernel slab, shown in this backtrace. 

I will find a way to disable it.
```
[    4.050330]  ? die+0x32/0x80
[    4.050809]  ? do_trap+0xd6/0x100
[    4.051365]  ? __slab_free+0x16c/0x380
[    4.052198]  ? do_error_trap+0x6a/0x90
[    4.052767]  ? __slab_free+0x16c/0x380
[    4.053350]  ? exc_invalid_op+0x4c/0x60
[    4.053916]  ? __slab_free+0x16c/0x380
[    4.055031]  ? asm_exc_invalid_op+0x16/0x20
[    4.055675]  ? tcp_rcv_state_process+0x791/0xef0
[    4.056527]  ? __slab_free+0x16c/0x380
[    4.057097]  ? lock_timer_base+0x61/0x80
[    4.057795]  ? tcp_get_metrics+0x142/0x380
[    4.058560]  ? tcp_rcv_state_process+0x791/0xef0
[    4.059265]  kmem_cache_free+0x599/0x5e0
[    4.059915]  tcp_rcv_state_process+0x791/0xef0
[    4.060918]  ? security_sock_rcv_skb+0x31/0x50
[    4.061857]  ? sk_filter_trim_cap+0x11a/0x290
[    4.062558]  tcp_v4_do_rcv+0xcd/0x280
[    4.063281]  tcp_v4_rcv+0xf81/0x1010
[    4.063832]  ? raw_local_deliver+0xcd/0x250
[    4.064668]  ip_protocol_deliver_rcu+0x32/0x320
[    4.065355]  ip_local_deliver_finish+0x7a/0xa0
[    4.066455]  ip_sublist_rcv_finish+0x7e/0x90
[    4.067231]  ip_sublist_rcv+0x1e1/0x220
[    4.067919]  ? __netif_receive_skb_core.constprop.0+0xbf/0x1080
[    4.068822]  ip_list_rcv+0x139/0x170
[    4.069362]  __netif_receive_skb_list_core+0x29d/0x2c0
[    4.070173]  ? __pfx_csum_block_add_ext+0x10/0x10
[    4.071054]  netif_receive_skb_list_internal+0x1e1/0x310
[    4.072068]  napi_complete_done+0x6e/0x1a0
[    4.072752]  virtnet_poll+0x40d/0x5a0
[    4.073313]  __napi_poll+0x28/0x1c0
[    4.073854]  net_rx_action+0x14c/0x2d0
[    4.074622]  ? vp_vring_interrupt+0x73/0x90
[    4.075746]  __do_softirq+0xf6/0x30f
[    4.076379]  __irq_exit_rcu+0x79/0xc0
[    4.077356]  common_interrupt+0xb9/0xd0
```
