# CVE-2024-57725: GPON Link Manipulation Vulnerability in certain Arcadyan Routers (Distributed by Orange and Jazztel)

This repository documents an unauthenticated vulnerability discovered in LiveboxFibra Arcadyan routers distributed by Orange and Jazztel in Spain (PRV3399B_B_LT). The issue lies in the ability to extract and modify the GPON link value via the `/cgi/cgi_authpage.js` and `/firstconnection.cgi` endpoints without authentication.

## Vulnerability Details

### Affected Endpoints
1. **`/cgi/cgi_authpage.js`**
   - Reveals the `slid_value` parameter, which contains the GPON link value in hexadecimal format. This can be accessed **without authentication**, leading to an information disclosure.

2. **`/firstconnection.cgi`**
   - Allows **unauthenticated modification of the GPON link value**. Attackers can:
     - Send a crafted POST request to change the GPON link, causing a denial of service (DoS) by disrupting the router's internet connectivity.

### Impact
- **Information Disclosure**: Extraction of the GPON password without authentication.
- **Denial of Service**: Unauthorized changes to the GPON value can disconnect the router from the internet.
- **Exploitation Vector**: Attackers must have local network access or exploit conditions where the router's authentication panel is exposed to the internet or accessible via a VPN tunnel.

## Exploitation Steps

### Extracting the GPON Password
1. Access the endpoint:
   ```
   https://<router-ip>/cgi/cgi_authpage.js
   ```
2. Locate the `slid_value` parameter in the JSON response to obtain the GPON password in hexadecimal format.

### Modifying the GPON Password
1. Send a POST request to `/firstconnection.cgi` with the following payload:
   ```
   GO=firstconnection.htm&pws=<BASE64_HEX_GPON_PWD>&GO=firstconnection.htm
   ```
   Replace `<BASE64_HEX_GPON_PWD>` with the desired GPON value, encoded in hexadecimal and then in base64.
2. Set the `Content-Type` header to `text/plain;charset=UTF-8`.

### Example PoC Script
Refer to the [change ONT value PoC Script](change_ont_value.py) or [check ONT value PoC Script](check_ont_value.py) for automating these steps.

## Recommended Fixes
- Implement authentication checks for the `/cgi/cgi_authpage.js` and `/firstconnection.htm` endpoints.
- Limit access to these endpoints to authorized users only or check if the user is in LAN for lower risk.

## Disclaimer
This repository is intended for educational and research purposes only. Do not use this information to exploit devices without authorization. Always act responsibly and ethically.

---

For more information or to report additional findings, please contact the repository owner or send email to pointedpentesting@gmail.com
