# CVE-2024-57523 - CSRF Vulnerability in Users.php - SourceCodester Packers and Movers Management System 1.0

## Description

This repository contains a Proof of Concept (PoC) for a **Cross-Site Request Forgery (CSRF)** vulnerability in the **Packers and Movers Management System 1.0** by **SourceCodester**. The vulnerability exists in the **Users.php** endpoint, which allows attackers to create unauthorized admin accounts by sending crafted requests to an authenticated admin user.

## Vulnerability Details

- **CVE-2024-57523**
- **Affected Product:** Packers and Movers Management System 1.0
- **Affected Component:** Users.php endpoint
- **Attack Type:** Remote
- **Impact:** Privilege Escalation, Information Disclosure
- **Security Implications:** Exploiting this vulnerability allows attackers to create unauthorized admin accounts, leading to privilege escalation and potential further attacks or data breaches.

## Proof of Concept (PoC)

This repository includes a PoC video, **CVE-2024-57523.mkv**, demonstrating how an attacker can exploit this CSRF vulnerability to create an admin account without proper authorization. The PoC showcases the process of crafting a malicious request that is triggered when an authenticated admin unknowingly visits a crafted page.

## Attack Vectors

- Exploitation requires an authenticated admin user to unknowingly execute a crafted script sent by an attacker.

## Mitigation Recommendations

To mitigate this vulnerability, the following security measures are recommended:

1. **CSRF Protection:** Implement CSRF tokens in all forms that perform state-changing actions (e.g., creating users), ensuring each request is validated with a unique session token.
2. **SameSite Cookies:** Set the `SameSite` attribute on session cookies to restrict their sending to requests originating from the same site, reducing the likelihood of CSRF attacks.
3. **Action Validation:** Introduce additional verification mechanisms, such as confirming high-impact actions like creating admin accounts via prompts or email verification.

## Vendor Information

- **Vendor:** SourceCodester
- **Product URL:** [SourceCodester Packers and Movers Management System](http://sourcecodester.com)

## Affected Versions

- Packers and Movers Management System 1.0

## Discoverer

- **Madhav Shah** - Security Researcher

## References

- [Packers and Movers Management System Official Website](http://packers.com)
- [SourceCodester](http://sourcecodester.com)

---
