---

# CVE-2024-57522 - Stored XSS Vulnerability in Users.php - SourceCodester Packers and Movers Management System 1.0

## Description

This repository contains a Proof of Concept (PoC) for a **Stored Cross-Site Scripting (XSS)** vulnerability in the **Packers and Movers Management System 1.0** by **SourceCodester**. The vulnerability is present in the **Users.php** endpoint, where an attacker can inject a malicious script into the username or name field during user creation. The script is then stored in the database and executed when an admin views the user list page, resulting in potential malicious actions.

## Vulnerability Details

- **CVE-2024-57522**
- **Affected Product:** Packers and Movers Management System 1.0
- **Affected Component:** Users.php endpoint
- **Attack Type:** Remote
- **Impact:** Malicious Script Execution, Session Hijacking, Phishing, Malicious Redirects
- **Security Implications:** The attacker can inject and execute arbitrary JavaScript code in the context of an admin's browser. The injected script remains persistent, allowing for session hijacking, phishing, and other malicious activities when an admin views the user list page.

## Proof of Concept (PoC)

This repository includes a PoC video, **CVE-2024-57522.mkv**, demonstrating how an attacker can exploit the XSS vulnerability. The PoC shows how an attacker can create a new admin user with a payload in the name field (e.g., `<script>alert(1);</script>`). When the admin visits the user list page, the malicious script executes, showing an alert with the message "1."

## Attack Vectors

- The attacker crafts a CSRF exploit to create an admin user with a malicious script injected into the name field. Using **CVE-2024-57523**  
- The malicious script is stored in the database and executed when an admin visits the user list page.

## Mitigation Recommendations

To mitigate this vulnerability, the following security measures are recommended:

1. **CSRF Protection:** Implement CSRF tokens in all forms that perform state-changing actions, such as user creation, to prevent unauthorized requests.
2. **Input Validation and Sanitization:** Properly sanitize and escape user inputs, especially for fields like usernames or names, to prevent the injection of malicious scripts.
3. **Content Security Policy (CSP):** Implement a CSP to reduce the potential impact of XSS vulnerabilities by restricting the sources from which scripts can be loaded.
4. **Escaping User-Generated Content:** Ensure that user-generated content is validated and escaped before rendering it in the browser to prevent script execution.

## Vendor Information

- **Vendor:** SourceCodester
- **Product URL:** [SourceCodester Packers and Movers Management System](http://sourcecodester.com)

## Affected Versions

- Packers and Movers Management System 1.0

## Discoverer

- **Madhav Shah** - Security Researcher

## References

- [Packers and Movers Management System Official Website](http://packers.com)
- [SourceCodester](http://sourcecodester.com)

---
