# CVE-2024-56924

# Vulnerability Description
<h5>A Cross-Site Request Forgery (CSRF) vulnerability exists in the code astro Internet Banking System version 2.0.0, which allows remote attackers to perform unauthorized actions on behalf of authenticated users, such as administrators, without their knowledge. By crafting a malicious HTML page, an attacker can trick an authenticated user (such as an admin) into submitting a request to modify sensitive account details (e.g., name, email) on the target system. This vulnerability arises due to the lack of CSRF protection on the account modification page (e.g., pages_account.php), allowing an attacker to bypass security mechanisms and execute unauthorized actions on the user's behalf.</h5>

# Versions Affected
<h5>2.0.0</h5>

# Researcher
<h5>Pratheep M</h5>

# Proof Of Concept

<h3>STEP BY STEP PROCEDURE</h3>
<h5>I have added the video POC for your reference below.</h5>

<h5>STEP 1: Click on the Admin Portal and log in using the default credentials.</h5>
<h5>STEP 2: Navigate to the Accounts section and use Burp Suite to intercept the request.</h5>
<h5>STEP 3: Click the Update button and capture the request. Then, right-click on the panel, go to Engagement Tools → Generate CSRF PoC.</h5>
<h5>STEP 4: Modify the request to update the name and email fields, and click Test in Browser.</h5>
<h5>STEP 5: Paste the PoC into the browser, and you will observe that the name and email have been successfully changed.</h5>

# Video POC

<p><img align="center" alt="poc" src="https://github.com/ipratheep/CVE-2024-56924/blob/main/poc.gif" width="700" height="400"></p>
