# 🚨 Simple Dashboard <= 2.0 - Unauthenticated Privilege Escalation

## 📄 Description
The Simple Dashboard plugin for WordPress is vulnerable to Privilege Escalation in all versions up to, and including, 2.0.  
This makes it possible for unauthenticated attackers to elevate their privileges to that of an administrator.

- **CVE:** CVE-2024-56071  
- **CVSS:** 9.8 (Critical)

---

## 🛠️ Exploitation Logic

Although the vulnerability is due to a missing capability check (no `current_user_can()`), WordPress core **protects `/wp-admin/` from unauthenticated access**.

➡️ This means the vulnerability is **only exploitable after login**, but the **user does not need any special privileges**.  
Even a **Subscriber** can exploit this vulnerability and change sensitive WordPress options.

After exploiting by uploading a JSON file containing:
```json
{ "default_role": "administrator" }
```
Any new user who registers will automatically receive **Administrator** role.

---

## ⚙️ Usage

```bash
usage: CVE-2024-56071.py [-h] -u URL -U USERNAME -P PASSWORD

Exploit for Simple Dashboard <= 2.0 - Privilege Escalation # By Khaled Alenazi

options:
  -h, --help              show this help message and exit
  -u, --url URL           Target WordPress base URL (e.g., http://target.com/wordpress)
  -U, --username USERNAME WordPress username to log in
  -P, --password PASSWORD Password for the WordPress user
```

---

By: Nxploited | Khaled Alenazi
