# Laravel Crypto Killer Mass Scanner (CVE-2024-55555)

This script performs a mass scan of Laravel-based applications vulnerable to [CVE-2024-55555](https://nvd.nist.gov/vuln/detail/CVE-2024-55555), an **unauthenticated remote code execution (RCE)** vulnerability in [Invoice Ninja](https://www.synacktiv.com/advisories/invoiceninja-unauthenticated-remote-command-execution-when-appkey-known). It automates the process of detecting sites using weak or known `APP_KEY` values and checks whether they are vulnerable.

## 📌 How It Works

1. Reads a list of domains from `list.txt`.
2. Sends a request to each target and captures the Laravel-encrypted cookie (excluding `XSRF-TOKEN`).
3. Runs a brute-force decryption using [laravel-crypto-killer](https://github.com/synacktiv/laravel-crypto-killer) to find a valid `APP_KEY`.
4. If a valid key is found, the result is saved to `result.txt` in the format:

```
domain.tld|base64:APP_KEY
```

## 🧱 Requirements

Before using this tool, you **must install and configure** [`laravel-crypto-killer`](https://github.com/synacktiv/laravel-crypto-killer).

### 🔧 Install Laravel-Crypto-Killer

```bash
git clone https://github.com/synacktiv/laravel-crypto-killer.git
cd laravel-crypto-killer
pip install -r requirements.txt
```

> ⚠️ It's recommended to use a Python virtual environment.

### 🗂️ Wordlists

Ensure that the `wordlists/` folder contains appropriate keys to brute-force with. You can use the default ones or add your own `APP_KEY` values (in `base64:` format).

## 🚀 Usage

1. Prepare your `list.txt` with one domain per line (no `http` or `https` required):

```
ninja.example.com
account.example.com
```

2. Run the script:

```bash
python3 mass_laravel_crypto_bruteforce.py
```

3. If successful, the script will output:

```
[+] Key found for account.example.com: base64:RR++yb2rJ9kdtbrh3+AmbHLDtu+Q79i++co9Y8ybbno=
```

And save it in `result.txt`.

## 🛡️ About CVE-2024-55555

- **Vulnerability**: Invoice Ninja does not properly secure Laravel `APP_KEY` usage.
- **Impact**: If the `APP_KEY` is known or guessable, remote attackers can:
  - Decrypt cookies or serialized data.
  - Craft malicious payloads.
  - Execute arbitrary PHP code.
- **Reference**:
  - [Synacktiv Advisory](https://www.synacktiv.com/advisories/invoiceninja-unauthenticated-remote-command-execution-when-appkey-known)
  - [CVE-2024-55555 - NVD](https://nvd.nist.gov/vuln/detail/CVE-2024-55555)

## 🧠 Notes

- The script automatically selects the longest cookie (excluding `XSRF-TOKEN`) assuming it's the encrypted session.
- Parallel scanning is supported via `ThreadPoolExecutor` for faster performance.
- Only targets with Laravel-encrypted cookies will be processed.

## ✅ Example Output

```bash
[+] Key found for account.example.com: base64:RR++yb2rJ9kdtbrh3+AmbHLDtu+Q79i++co9Y8ybbno=
```

## ⚠️ Disclaimer

This tool is for **educational and authorized testing** only.  
Do **not** use this on systems without explicit permission.  
You are solely responsible for your actions.
