# CVE-2024-53924

- Description: Pycel through 1.0b30, when operating on an untrusted spreadsheet, allows code execution via a crafted formula in a cell, such as one beginning with the `=IF(A1=200, eval("__import__('os').system(` substring.
- Author: Adham Elmosalamy (@aelmo)
- Date of Disclosure: November 23, 2024
- Link: https://nvd.nist.gov/vuln/detail/CVE-2024-53924

## Summary

Pycel, a Python library for working with Excel worksheets including symbolic safe evaluation of Excel formulas suffer from a code execution vulnerability where Python-native functions that are otherwise blocked could be executed using specially crafted Excel formulas. This allows an attacker to provide a malicious document that leads to code execution when evaluated by Pycel.

Using the same demo script in the [Pycel documentation](https://pypi.org/project/pycel/), analyzing an Excel document should evaluate Excel functions and return an error such as `"Function EVAL is not implemented. EVAL is not a known Excel function"` and refuse to run.

However, I was able to bypass this using a malicious Excel formula that unexpectedly leads to arbitrary code execution when run in Pycel.

## Advisory

Pycel is currently insecure and cannot be trusted for evaluating or working with worksheets from untrusted origins. Failure
to do so can lead to devastating results in the form of code execution.

## Steps to Reproduce

1. Create an Excel sheet, place one of the following malicious formulas in any evaluated cell:
```vb
=IF(A1=200, eval("__import__('os').system('calc.exe')"), @LINEST(C1:C18,B1:B18))
=A1*eval("__import__('os').system('calc.exe')")
```
2. Run the Python script below (`pip install -r requirements.txt` first)
3. During runtime, and within the conditions =IF, the Python eval function does not get validated leading to code execution.

This is still valid for latest Pycel version 1.0b30.

