require('dotenv').config();
const express = require('express');
const mongoose = require('mongoose');
const bodyParser = require('body-parser');

const app = express();
const PORT = 3000;


mongoose.connect(process.env.MONGO_URI, {
    useNewUrlParser: true,
    useUnifiedTopology: true,
});

const db = mongoose.connection;
db.on('error', console.error.bind(console, 'Connection error:'));
db.once('open', () => console.log('Connected to MongoDB'));


const userSchema = new mongoose.Schema({
    username: String,
    password: String
});

const User = mongoose.model('User', userSchema);

app.use(bodyParser.json());
app.use(express.static('public'));

app.post('/login', async (req, res) => {
    const { username } = req.body;
    try {
        console.log("Received login request for:", username); // Debugging log
        const user = await User.findOne({ username: { $eq: username } });
        
        if (user) {
            return res.json({ message: 'Login Successful! Here is your flag: FLAG{MONGO_RCE_2025}' });
        }

        res.json({ message: 'Invalid username!' });
    } catch (error) {
        console.error("🔥 ERROR:", error); // Show full error
        res.status(500).json({ message: 'Server error', error: error.message });
    }
});


app.listen(PORT, () => console.log(`Server running on http://localhost:${PORT}`));
