CTF Challenge - Mongoose RCE (CVE-2024-53900)

Challenge Overview
This Capture The Flag (CTF) challenge is based on CVE-2024-53900, a vulnerability in Mongoose that allows Remote Code Execution (RCE) due to improper use of the `$where` operator in MongoDB queries. 

Your objective is to exploit this vulnerability and retrieve the flag hidden inside the application!

Setup Instructions

1 Install Dependencies
Make sure you have Node.js installed, then run:
```sh
npm install
```
2 Configure MongoDB
Install MongoDB and ensure it is running.
Create a .env file in the root directory with the following:
```sh
MONGO_URI=mongodb://localhost:27017/ctf_db
```
3 Start the Server
Run the vulnerable Express server:
```sh
node server.js
```
The server will start at: http://localhost:3000

Challenge Objective

Your goal is to bypass authentication and extract the flag from the vulnerable endpoint.

Vulnerable Endpoint:
POST /login
The application uses an insecure MongoDB `$where` query, making it vulnerable to NoSQL injection & RCE.

Exploitation Hint:
Try NoSQL injection payloads to manipulate the query.
Inject JavaScript code into the `$where` condition.
Retrieve the flag hidden inside the response.

Directory Structure
```sh
│── public/                     Frontend assets
│   ├── index.html               CTF challenge UI
│   ├── style.css                Styling for the challenge
│   └── script.js                JavaScript for login request
│── .env                         Environment variables (MongoDB URI)
│── server.js                     Vulnerable Express.js server
│── package.json                  Dependencies & scripts
│── package-lock.json             Lock file for dependencies
└── README.md                     Challenge guide (this file)
```

Winning Condition

If you successfully exploit the vulnerability, you will get the response:

Login Successful! Here is your flag: FLAG{*****_***_****}
