# CVE-2024-53376
CyberPanel Authenticated OS Command Injection

### Affected Devices
CyberPanel versions < 2.3.8 are vulnerable to an OS command injection. To exploit the vulnerability the attacker is required to firstly login to the webpanel. 

### Tested With
CyberPanel 2.3.7

### Technical details

An attacker can use a HTTP OPTIONS request to instruct the webserver running the CyberPanel application to execute arbitrary commands. This vulnerability lies in the /websites/submitWebsiteCreation endpoint.

This endpoint calls the submitWebsiteCreation function in the /websiteFunctions/views.py file location. 

<p align="center"> <img src="https://github.com/ThottySploity/CVE-2024-53376/blob/main/images/submitWebsiteCreation_views.png" alt="Toplevel function" /> </p>

This function further calls the `wm.submitWebsiteCreation` function found in the /websiteFunctions/website.py file. This function extracts five parameters which are used within the function:
    - domain;
    - adminEmail;
    - phpSelection;
    - packageName;
    - websiteOwner;

<p align="center"> <img src="https://github.com/ThottySploity/CVE-2024-53376/blob/main/images/submitWebsiteCreation_part1.png" alt="Toplevel function" /> </p>

These parameters are later parsed directly to a function that executes these:

<p align="center"> <img src="https://github.com/ThottySploity/CVE-2024-53376/blob/main/images/submitWebsiteCreation_part2.png" alt="Toplevel function" /> </p>

The Proof-of-Concept (PoC) code can be found in the cyberpanel.py file that is linked in this repo.

### PoC

This Proof-of-Concept can be used to write files with root level permissions, anywhere on the system:

<p align="center"> <img src="https://github.com/ThottySploity/CVE-2024-53376/blob/main/images/writing_into_root.png" alt="Toplevel function" /> </p>

This could result in a complete device compromise. If the device's CyberPanel installation folder is accessible, data can be more easily extracted through the web panel.

### Writeup 

The writeup which outlines the discovery process of the exploit will become available at: https://thottysploity.github.io/posts/cve-2024-53376

### Timeline

30.10.2024 - Identified vulnerability  
31.10.2024 - Contacted Usman Nasir, owner of CyberPanel  
02.11.2024 - Usman fixed the issue and published a fix  
03.11.2024 - Requested CVE-ID from MITRE  
23.11.2024 - MITRE reserved CVE-ID 2024-53376  
15.12.2024 - CVE-2024-53376 published to the public  