# CVE-2024-53375
TP-Link Archer series routers Authenticated OS Command Injection

### Affected Devices
TP-Link devices that use the HomeShield functionality are vulnerable to this exploit. This encompasses multiple routers from the TP-Link Archer series.

### Tested With
Archer AXE75(EU)_V1_1.2.2 Build 20240827 (Publication date November 4, 2024)

### Technical details

An attacker can use a HTTP POST request to instruct the router to execute arbitrary commands. This vulnerability is callable from the /admin/smart_network?form=tmp_avira endpoint. A valid session is required. 

This endpoint calls the following function in the avira.lua file:

<p align="center"> <img src="https://github.com/ThottySploity/CVE-2024-53375/blob/main/images/vulnerable_code.png" alt="Vulnerable Code" /> </p>

This code harbors a Remote Code Execution (RCE) vulnerability because it parses the `OwnerId` directly to the `os.execute` function, without any sanitization nor checks.
To exploit this vulnerability five parameters need to be set:
    - ownerId
    - date (which is a string (today/yesterday))
    - type (needs to be "visit")
    - startIndex
    - amount

The Proof-of-Concept (PoC) code can be found in the archer.py file that is linked in this repo.

### PoC
Using the exploit for extracting the /etc/shadow' file and the /etc/passwd file

<p align="center"> <img src="https://github.com/ThottySploity/CVE-2024-53375/blob/main/images/before_exploit.png" alt="PoC before exploit" /> </p>

After firing the exploit and refreshing the page, the contents of the /etc/shadow file and the /etc/passwd file can be seen.

<p align="center"> <img src="https://github.com/ThottySploity/CVE-2024-53375/blob/main/images/dumping_passwords.png" alt="PoC after exploit" /> </p>

We can also issue the id command to see what user we're running as

<p align="center"> <img src="https://github.com/ThottySploity/CVE-2024-53375/blob/main/images/root.png" alt="PoC user" /> </p>


### Writeup

The website https://thottysploity.github.io/posts/cve-2024-53375 outlines the discovery process of the exploit and provides details on how the exploit was tested.


### Timeline
03.10.2024 - Identified vulnerability  
04.10.2024 - Contacted Zero Day Initiative (ZDI)  
10.10.2024 - ZDI was not interested in aquiring the vulnerability  
10.10.2024 - Contacted TP-Link with information about the vulnerability  
12.10.2024 - TP-Link forwarded information to person for analysis  
30.10.2024 - Requested CVE-ID from MITRE  
08.11.2024 - TP-Link acknowledged vulnerability and provided fixed beta firmware version  
23.11.2024 - MITRE reserved CVE-ID 2024-53375
