# CVE-2024-53027-WIP
Work in Progress for POC

# CVE-2024-53027: Qualcomm Bluetooth/Wi-Fi Vulnerability

## 📄 Overview

**CVE-2024-53027** is a medium-severity vulnerability (CVSS unrated) affecting **Qualcomm’s WLAN and Bluetooth chipsets** in Android devices. It can cause **transient denial-of-service (DoS)** when processing **malformed country information elements (IEs)** in wireless packets.

## 🧩 Affected Components

- **Qualcomm WLAN firmware**  
- **Bluetooth stacks in Snapdragon chipsets** (specific models unconfirmed)

## ⚠️ Impact

- **Exploitation**: Remote attackers within Wi-Fi/Bluetooth range can **crash the chipset’s firmware**, disrupting connectivity until reboot.  
- **Limitations**: No evidence of code execution or persistent compromise. Requires **proximity** and **targeted packet injection**.

## 🛠️ Mitigation

- **Patched** in Qualcomm’s **March 2025 security bulletin** (**QSB-2025-03**)  
- Android vendors must **integrate fixes via OTA updates**

## 📱 Affected Android Versions

The vulnerability impacts:

- Android 12  
- Android 12L  
- Android 13  
- Android 14  
- Android 15  

Devices running these versions—including **smartphones, tablets, and IoT devices**—are at risk if unpatched.

## 🏷️ Key OEMs & Devices Potentially Affected

- **Google Pixel** (Pixel 6 and newer, if running vulnerable OS versions)  
- **Samsung Galaxy** (One UI-based devices on Android 12–15)  
- **OnePlus, Xiaomi, Motorola**, and others using **Qualcomm/MediaTek chipsets** with unpatched firmware

## 🚨 Exploitation & Risks

- **Attack Vector**: Malicious apps exploiting weak **IPC (Inter-Process Communication)** validation  

**Impact**:

- Privilege escalation (system-level control)  
- Access to sensitive directories: `/Android/data`, `/Android/obb`  
- Potential spyware deployment (e.g., via tools like **Cellebrite UFED**)

## 🔒 Mitigation Status

- **Google Patch**: Released in **November 2024 Android Security Bulletin**  
  → Requires patch level **2024-11-05** or later  
- **OEM Delays**: Some manufacturers (e.g., Samsung, Xiaomi) may lag in distributing updates

## ⚠️ Disclaimer

The provided scripts and proof-of-concept code are intended **solely for educational and private testing purposes**. They must **only be executed on devices that you own or have explicit permission to test**.

By using these scripts, you agree to take full responsibility for any actions taken. **Unauthorized use on networks or devices you do not control may be illegal and is strictly prohibited.**

The author of this code is not liable for any damage, disruption, or legal consequences resulting from misuse. Always follow responsible disclosure and ethical testing guidelines.

# 🚨 Wi-Fi Beacon Country IE DoS PoC (CVE-2024-53027 Inspired)

This Proof-of-Concept (PoC) script sends malformed Wi-Fi beacon frames with an invalid Country Information Element (IE) to test the stability of WLAN chipsets (e.g. Qualcomm) against CVE-2024-53027–like issues.

## 🛠️ How to Use

### 1. Enable Monitor Mode

**Option A: Manually (ip + iw)**

```bash
sudo ip link set wlan0 down
sudo iw wlan0 set monitor control
sudo ip link set wlan0 up
```

**Option B:**
sudo airmon-ng start wlan0
