# CVE-2024-5243-pwn2own-toronto-2023

## TP-Link ER605 Pre-Auth RCE (CVE-2024-5242 / CVE-2024-5243 / CVE-2024-5244)

Proof-of-Concept (PoC) exploit chain targeting the TP-Link Omada ER605 DDNS client daemon (`cmxddnsd`) when the device is configured to use the Comexe DDNS service.

> ⚠️ **Legal / Ethics**: This repository is for **authorized security research** and **controlled lab reproduction** only. Do not use against systems you do not own or lack explicit permission to test.

---

## Overview

This PoC demonstrates a chaining approach that combines:
1) a spoofing/impersonation primitive against the DDNS protocol layer,  
2) an information leak to bypass ASLR, and  
3) a control-flow hijack leading to ROP-based code execution.

The chain corresponds to the following published issues:

| CVE | ZDI Advisory | Type (as described by ZDI/NVD) | High-level role in a chain |
|---|---|---|---|
| CVE-2024-5244 | ZDI-24-503 | Reliance on security through obscurity (DDNS messages can be accessed/spoofed) | Enables crafting/spoofing valid-looking DDNS messages |
| CVE-2024-5243 | ZDI-24-502 | Buffer overflow in handling of DNS names | Used to influence/poison DNS-name-related state and enable an ASLR bypass leak path |
| CVE-2024-5242 | ZDI-24-501 | Stack-based buffer overflow in handling of DDNS error codes | Used as the control-flow hijack primitive for ROP-based RCE |

> Note: This README aligns the **CVE ↔ issue description** to ZDI/NVD wording. The exact exploit choreography can vary by firmware build and local reproduction details; see `exploit.py` and analysis notes in this repo.

---

## Affected Versions

- **Target**: TP-Link Omada ER605 VPN Router
- **Vulnerable**: `< ER605(UN)_V2_2.2.4`
- **Tested on**: `2.2.2`
- **Fixed in**: `ER605(UN)_V2_2.2.4 Build 20240119` (and later)

---

## Threat Model / Preconditions (High-level)

ZDI describes the impact as **network-adjacent** when Comexe DDNS is enabled/configured. In practice, a reproduction typically requires the ability to observe and influence the router’s DDNS/DNS traffic path sufficiently to:
- redirect/impersonate the Comexe DDNS server side, and
- deliver crafted DDNS responses to the router.

This repo intentionally avoids step-by-step operational guidance for achieving that positioning outside of a controlled lab.

---

## Attack Flow (Conceptual)

```
┌─────────────────┐                    ┌─────────────────────────┐
│   TP-Link ER605  │                    │        Attacker         │
│   (cmxddnsd)     │                    │ (authorized lab setup)  │
└───────┬─────────┘                    └───────────┬─────────────┘
        │                                          │
        │ (1) DDNS message spoofing/impersonation  │  CVE-2024-5244
        │<-----------------------------------------│
        │                                          │
        │ (2) Parsing-time overflow affects DNS-   │  CVE-2024-5243
        │     name-related state; later leak occurs│
        │     in DNS query sending path (e.g.,     │
        │     sndDnsQuery) to bypass ASLR          │
        │<-----------------------------------------│
        │                                          │
        │ (3) Error-code overflow for control-flow │  CVE-2024-5242
        │     hijack → ROP → system(command)       │
        │<-----------------------------------------│
```

Key separation:
- **Parsing overflows** are triggered during DDNS message parsing (notably via `_chkPkt`-adjacent parsing logic for error codes / DNS-name handling).
- The **ASLR-bypass leak** is achieved later via the **DNS query sending path** after poisoning DNS-name-related state.

---

## Repository Contents

- `exploit.py` — PoC implementation used for lab reproduction (requires filling in build-specific constants/offsets).
- `README.md` — This document.

---

## Configuration Notes (Build-specific)

This PoC requires build-specific values (e.g., offsets, gadget locations, leak interpretation) that depend on the target firmware and libc. These values are intentionally left as placeholders and must be derived via analysis of the tested build.

Example placeholders (see `exploit.py`):
- libc base derivation (leak offset → libc base)
- `system()` offset
- a suitable MIPS gadget sequence and constraints
- an address for a stable command string reference used by the ROP chain

---

## Technical Notes (High-level)

### Root Cause Pattern (Conceptual)

A recurring anti-pattern in the parsing logic is copying attacker-controlled field data using a delimiter-derived length without properly bounding it to the destination buffer size (conceptually):

```c
char *end = strchr(ptr, '\x01');   // delimiter
int len = end - ptr;               // attacker-influenced length
memcpy_or_strncpy(dest, ptr, len); // missing bounds check -> overflow
```

### ROP Gadget (MIPS delay slot)

The PoC uses a MIPS delay-slot-friendly gadget shape:

```asm
move    $t9, $s0
jalr    $t9
move    $a0, $s1      ; delay slot
```

By controlling `$s0` and `$s1` via saved-register overwrite, this enables a compact `system(command)` call sequence.

### Payload Constraints (Implementation-dependent)

Practical payload construction is constrained by:
- protocol field delimiters (e.g., `\x01`), and
- string/parsing behavior that may truncate or alter copied data.

See `exploit.py` for the exact constraints used in this reproduction.

---

## Disclaimer

This code and documentation are provided for educational purposes and authorized security research only. Any use without explicit permission is prohibited and may be illegal.

---

## Credits

- Original vulnerability discovery and Pwn2Own Toronto 2023 research: Claroty Research Team82
- This repo: independent reproduction and analysis work

---

## References

- ZDI-24-501 (CVE-2024-5242): https://www.zerodayinitiative.com/advisories/ZDI-24-501/
- ZDI-24-502 (CVE-2024-5243): https://www.zerodayinitiative.com/advisories/ZDI-24-502/
- ZDI-24-503 (CVE-2024-5244): https://www.zerodayinitiative.com/advisories/ZDI-24-503/
- NVD entries:
  - CVE-2024-5242: https://nvd.nist.gov/vuln/detail/CVE-2024-5242
  - CVE-2024-5243: https://nvd.nist.gov/vuln/detail/CVE-2024-5243
  - CVE-2024-5244: https://nvd.nist.gov/vuln/detail/CVE-2024-5244

---

