# CVE-2024-52302: Unrestricted File Upload Vulnerability in Common-User-Management

## Overview

I discovered a critical security vulnerability in **common-user-management**, a robust Spring Boot application featuring user management services designed to control user access dynamically. This vulnerability affects the `/api/v1/customer/profile-picture` endpoint, allowing attackers to upload files without proper validation, which can lead to **Remote Code Execution (RCE)**.

## Exploit Code

You can exploit this vulnerability using the following Python script:

```bash
python exploit.py -u "customer_user" -p "your_password" -f "malicious.jsp" -url "https://target.com"
```

## Parameters:

    -u: Username
    -p: Password
    -f: Malicious file to upload 
    -url: Target URL

    
## Summary

There is a critical security vulnerability in the endpoint /api/v1/customer/profile-picture. This endpoint allows file uploads without proper validation or restrictions, enabling attackers to upload malicious files that can lead to Remote Code Execution (RCE).
Vulnerability Description

The issue stems from a lack of validation on the file extension and the Content-Type header. As a result, the application permits the upload of arbitrary files, including:

HTML files (tested)
Server-side script files (e.g., JSP, PHP, ASP, etc.)

These files can then be executed by the web server, allowing attackers to execute arbitrary code on the server, potentially compromising the entire system.

## Steps to Reproduce

1. Upload Malicious File:
Send a PUT request to /api/v1/customer/profile-picture using customer with role 26,17 added with a malicious file payload (e.g., .jsp, .php, .html).

2. GET the file location:
Send GET request /api/v1/customer/my-profile , grap the file location in response with the profile's link.

4. Execute the Uploaded File:
Using the file name access the file directly through the URL returned in the response.
If the server supports the uploaded file type, it will execute the file, leading to Remote Code Execution.


## Links:

- https://www.exploit-db.com/exploits/52206
- https://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2024-52302
- https://nvd.nist.gov/vuln/detail/CVE-2024-52302
- https://www.tenable.com/cve/CVE-2024-52302
- https://vuldb.com/de/?id.284573
