# CVE-2024-52301-Research
A bit of research around CVE-2024-52301. I've seen the vuln and wanted to find out how Laravel is vulnerable. For this, I just diffed the 6.20.44 and 6.20.45 versions, and traced how GET parameters could end up changing the application configuration.

I've written about this on X and BlueSky:
- https://x.com/0xntrm/status/1857504510609965206
- https://bsky.app/profile/ntrm.bsky.social/post/3laz4tkds2k2m

# Contents

This repo contains a simple docker compose file and some php:
- phpinfo.php to check, whether the `register_argc_argv` is on or off
- exploit.php contains the relevant methods from Laravel version 6, stripped from dependencies and unnecessary stuff

# Run the thing

```bash
docker-compose up -d

curl 'localhost:8000/exploit.php?--env=development'

```

# Sources
https://www.cert.at/de/warnungen/2024/11/kritische-sicherheitslucke-in-laravel-framework-updates-verfugbar
https://securityonline.info/critical-laravel-flaw-cve-2024-52301-exposes-millions-of-web-applications-to-attack/
